/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.x509.certificate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import shaded.cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.util.SM2OIDUtil;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.CRLDistPoint;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.DistributionPoint;
import shaded.cfca.sadk.x509.certificate.X509CRL;
import shaded.cfca.sadk.x509.certificate.X509Cert;

public class X509CertVerifier {
    private static Hashtable table = new Hashtable();

    public static void updateTrustCertsMap(String trustCerPath) throws PKIException {
        try {
            X509Cert trustCert = new X509Cert(new FileInputStream(trustCerPath));
            if (SM2OIDUtil.isSm3WithSM2Encryption(trustCert.getCertStructure()) || trustCert.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString().equals(PKCSObjectIdentifiers.rsaEncryption.toString())) {
                table.put(trustCert.getSubject(), trustCert.getPublicKey());
            }
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void updateTrustCertsMap(X509Cert trustCert) throws PKIException {
        try {
            if (SM2OIDUtil.isSm3WithSM2Encryption(trustCert.getCertStructure()) || trustCert.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString().equals(PKCSObjectIdentifiers.rsaEncryption.toString())) {
                table.put(trustCert.getSubject(), trustCert.getPublicKey());
            }
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void updateTrustCertsMap(X509Cert[] trustCerts) throws PKIException {
        try {
            X509Cert trustCert = null;
            int len = trustCerts.length;
            for (int i = 0; i < len; ++i) {
                trustCert = trustCerts[i];
                if (!SM2OIDUtil.isSm3WithSM2Encryption(trustCert.getCertStructure()) && !trustCert.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString().equals(PKCSObjectIdentifiers.rsaEncryption.toString())) continue;
                table.put(trustCert.getSubject(), trustCert.getPublicKey());
            }
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void clearTrustCertsMap() {
        table.clear();
    }

    public static boolean validateCertSign(X509Cert cert) throws PKIException {
        String issuer = cert.getIssuer();
        PublicKey pubKey = (PublicKey)table.get(issuer);
        if (pubKey != null) {
            return cert.verify(pubKey);
        }
        return false;
    }

    public static boolean verifyCertDate(X509Cert userCert) {
        Date current = new Date();
        Date start = userCert.getNotBefore();
        Date end = userCert.getNotAfter();
        return !current.before(start) && !current.after(end);
    }

    public static boolean verifyCertByCRLOutLine(X509Cert userCert, String crlPath) throws PKIException {
        File file = new File(crlPath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850906", "CRL\u6587\u4ef6\u4e0d\u5b58\u5728", ex);
        }
        X509CRL crl = new X509CRL(fis);
        return !crl.isRevoke(userCert.getSerialNumber());
    }

    public static String getCRLPointName(X509Cert userCert) throws PKIException {
        CRLDistPoint crlDistExt = userCert.getCRLDistributionPoints();
        int crlDistCount = crlDistExt.getDistributionPoints().length;
        String crl = null;
        for (int i = 0; i < crlDistCount; ++i) {
            DistributionPoint crlName = crlDistExt.getDistributionPoints()[i];
            String crlPointName = crlName.getDistributionPoint().toString();
            if (crlPointName.indexOf("ldap://") == -1) continue;
            crl = crlPointName;
        }
        if (crl == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u7684\u76ee\u5f55\u4fe1\u606f");
        }
        return crl;
    }

    public static boolean verifyCertByLDAP(X509Cert userCert) throws PKIException {
        String crl = X509CertVerifier.getCRLPointName(userCert);
        int ldapIndex = crl.indexOf("ldap://");
        crl = crl.substring(ldapIndex + 7, crl.length());
        ldapIndex = crl.indexOf(":");
        String ip = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("/");
        String port = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("?");
        String dn = crl.substring(0, ldapIndex);
        String cn = crl.substring(crl.indexOf("=") + 1, crl.indexOf(","));
        boolean revoke = false;
        X509CRL x509Crl = null;
        try {
            x509Crl = X509CertVerifier.getCRLFromLDAP(ip, port, dn, cn);
        }
        catch (Exception ex) {
            throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25", ex);
        }
        if (x509Crl != null) {
            revoke = x509Crl.isRevoke(userCert.getSerialNumber());
            return !revoke;
        }
        throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25");
    }

    private static X509CRL getCRLFromLDAP(String ip, String port, String dn, String cn) throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ip + ":" + port);
        env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
        ctx = new InitialDirContext(env);
        SearchControls tConstraints = new SearchControls();
        tConstraints.setSearchScope(2);
        NamingEnumeration<SearchResult> tResults = null;
        String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
        Object[] attrs = new String[]{"certificateRevocationList;binary"};
        X509CRL crl = null;
        tResults = ctx.search(dn, filter, attrs, tConstraints);
        if (tResults != null && tResults.hasMore()) {
            while (tResults.hasMore()) {
                SearchResult tSearchRel = tResults.next();
                Attributes allAttrs = tSearchRel.getAttributes();
                Attribute attCRL = allAttrs.get("certificateRevocationList;binary");
                byte[] bCRL = (byte[])attCRL.get(0);
                crl = new X509CRL(bCRL);
            }
        }
        ctx.close();
        return crl;
    }
}

