/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import shaded.cfca.sadk.algorithm.common.CBCParam;
import shaded.cfca.sadk.algorithm.common.Mechanism;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.algorithm.sm2.SM4Engine;
import shaded.cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import shaded.cfca.sadk.lib.crypto.Session;
import shaded.cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.system.global.FileAndBufferConfig;
import shaded.cfca.sadk.util.Base64;
import shaded.cfca.sadk.util.KeyUtil;
import shaded.cfca.sadk.x509.certificate.X509Cert;

public class EncryptUtil {
    private static boolean isHex(String str) {
        if (str == null) {
            return false;
        }
        String lowStr = str.toLowerCase();
        int len = lowStr.length();
        for (int i = 0; i < len; ++i) {
            if (lowStr.charAt(i) >= '0' && lowStr.charAt(i) <= '9' || lowStr.charAt(i) >= 'a' && lowStr.charAt(i) <= 'f') continue;
            return false;
        }
        return true;
    }

    private static byte[] HexToByte(String hexStr) throws UnsupportedEncodingException {
        byte[] lowerData = hexStr.toLowerCase().getBytes("UTF-8");
        int len = lowerData.length;
        byte[] workData = null;
        byte[] resultData = null;
        if (len % 2 == 1) {
            workData = new byte[++len];
            workData[0] = 0;
            System.arraycopy(lowerData, 0, workData, 1, len - 1);
        } else {
            workData = new byte[len];
            workData = (byte[])lowerData.clone();
        }
        int resultDataLen = len / 2;
        resultData = new byte[resultDataLen];
        for (int i = 0; i < len; i += 2) {
            byte datum;
            workData[i] = workData[i] >= 48 && workData[i] <= 57 ? (byte)(workData[i] - 48) : (byte)(workData[i] - 87);
            workData[i + 1] = workData[i + 1] >= 48 && workData[i + 1] <= 57 ? (byte)(workData[i + 1] - 48) : (byte)(workData[i + 1] - 87);
            resultData[i / 2] = datum = (byte)(workData[i] << 4 | workData[i + 1]);
        }
        return resultData;
    }

    private static byte[] doWithPWD(byte[] data, String pwd, boolean encryptFlag) throws Exception {
        byte[] ivKey = EncryptUtil.HexToByte(pwd);
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        byte[] iv = new byte[8];
        byte[] key = new byte[24];
        System.arraycopy(ivKey, 0, iv, 0, 8);
        System.arraycopy(ivKey, 8, key, 0, 24);
        CBCParam param = new CBCParam();
        param.setIv(iv);
        algName.setParam(param);
        if (encryptFlag) {
            return RSAAndItsCloseSymAlgUtil.crypto(false, true, key, data, algName);
        }
        return RSAAndItsCloseSymAlgUtil.crypto(false, false, key, data, algName);
    }

    public static String encryptMessageByDES3(String sourceData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] sourceData_utf8 = sourceData.getBytes("UTF-8");
                byte[] encryptData = EncryptUtil.doWithPWD(sourceData_utf8, password, true);
                return new String(Base64.encode(encryptData), "UTF-8");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = new X509Cert(certFilePath);
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageBySM2(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageBySM2(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, Key key, Session session) throws PKIException {
        PublicKey pubKey = null;
        if (!(key instanceof PublicKey)) {
            throw new PKIException("key is not Publickey, PublicKey expected!");
        }
        pubKey = (PublicKey)key;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.encrypt(mechanism, pubKey, sourceData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptData, String sm2FilePath, String sm2FilePwd, Session session) throws PKIException {
        SM2PrivateKey sm2PrivKey = KeyUtil.getPrivateKeyFromSM2(sm2FilePath, sm2FilePwd);
        return EncryptUtil.decryptMessageBySM2(encryptData, sm2PrivKey, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, Key key, Session session) throws PKIException {
        SM2PrivateKey sm2PrivKey = null;
        if (!(key instanceof SM2PrivateKey)) {
            throw new PKIException("key is not SM2PrivateKey, SM2PrivateKey expected!");
        }
        sm2PrivKey = (SM2PrivateKey)key;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.decrypt(mechanism, sm2PrivKey, encryptedData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = new X509Cert(certFilePath);
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageByRSA(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageByRSA(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, Key key, Session session) throws PKIException {
        PublicKey pubKey = null;
        if (!(key instanceof PublicKey)) {
            throw new PKIException("key is not Publickey, PublicKey expected!");
        }
        pubKey = (PublicKey)key;
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.encrypt(mechanism, pubKey, sourceData, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, String pfxFilePath, String pfxFilePwd, Session session) throws PKIException {
        PrivateKey prvKey = KeyUtil.getPrivateKeyFromPFX(pfxFilePath, pfxFilePwd);
        return EncryptUtil.decryptMessageByRSA(encryptData, prvKey, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, Key key, Session session) throws PKIException {
        PrivateKey prvKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new PKIException("key is not PrivateKey, PrivateKey expected!");
        }
        prvKey = (PrivateKey)key;
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.decrypt(mechanism, prvKey, encryptData, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptFileBySM2(String sourceFilePath, String encryptFilePath, X509Cert x509Cert, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            fos = new FileOutputStream(encryptFilePath);
            byte[] in = new byte[fis.available()];
            fis.read(in);
            byte[] out = EncryptUtil.encryptMessageBySM2(in, x509Cert, session);
            fos.write(out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFileBySM2(String encryptFilePath, String decryptFilePath, SM2PrivateKey sm2PrvKey, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            fos = new FileOutputStream(decryptFilePath);
            byte[] in = new byte[fis.available()];
            fis.read(in);
            byte[] out = EncryptUtil.decryptMessageBySM2(in, sm2PrvKey, session);
            fos.write(out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String decryptMessageByDES3(String encryptData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] encryptData_utf8 = Base64.decode(encryptData.getBytes("UTF-8"));
                byte[] sourceData = EncryptUtil.doWithPWD(encryptData_utf8, password, false);
                return new String(sourceData, "UTF-8");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void encryptFileByDES3(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam();
                param.setIv(iv);
                fos = new FileOutputStream(encryptFilePath);
                EncryptUtil.bigFileBlockEncrypt(true, key, (BlockCipher)new DESedeEngine(), param, new File(sourceFilePath), fos);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void decryptFileByDES3(String encryptFilePath, String plainTextFilePath, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam();
                param.setIv(iv);
                fos = new FileOutputStream(plainTextFilePath);
                EncryptUtil.bigFileBlockEncrypt(false, key, (BlockCipher)new DESedeEngine(), param, new File(encryptFilePath), fos);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void decryptFileByDES3(String encryptFilePath, ByteArrayOutputStream plainTextByteArrayOutputStream, String password) throws PKIException {
        block5: {
            if (EncryptUtil.isHex(password) && 64 == password.length()) {
                try {
                    byte[] ivKey = EncryptUtil.HexToByte(password);
                    byte[] iv = new byte[8];
                    byte[] key = new byte[24];
                    System.arraycopy(ivKey, 0, iv, 0, 8);
                    System.arraycopy(ivKey, 8, key, 0, 24);
                    CBCParam param = new CBCParam();
                    param.setIv(iv);
                    EncryptUtil.bigFileBlockEncrypt(false, key, (BlockCipher)new DESedeEngine(), param, new File(encryptFilePath), plainTextByteArrayOutputStream);
                    break block5;
                }
                catch (Exception e) {
                    throw new PKIException(e.getMessage());
                }
            }
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptFileBySM4(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            int dataLen = fis.available();
            plainTextData = new byte[dataLen];
            fis.read(plainTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        encryptTextData = EncryptUtil.pbeWithSM4Encrypt(true, password, plainTextData);
        try {
            fos = new FileOutputStream(encryptFilePath);
            fos.write(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, String password) throws PKIException {
        return Base64.encode(EncryptUtil.pbeWithSM4Encrypt(true, password, sourceData));
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, String password) throws PKIException {
        return EncryptUtil.pbeWithSM4Encrypt(false, password, Base64.decode(encryptData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFileBySM4(String encryptFilePath, String plainTextFilePath, String password) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            int dataLen = fis.available();
            encryptTextData = new byte[dataLen];
            fis.read(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        plainTextData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptTextData);
        try {
            fos = new FileOutputStream(plainTextFilePath);
            fos.write(plainTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFileBySM4(String encryptFilePath, ByteArrayOutputStream plainTextByteArrayOutputStream, String password) throws PKIException {
        FileInputStream fis = null;
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            int dataLen = fis.available();
            encryptTextData = new byte[dataLen];
            fis.read(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        plainTextData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptTextData);
        plainTextByteArrayOutputStream.write(plainTextData, 0, plainTextData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFileBySM4(String encryptFilePath, byte[] plainTextBytes, String password) throws PKIException {
        FileInputStream fis = null;
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            int dataLen = fis.available();
            encryptTextData = new byte[dataLen];
            fis.read(encryptTextData);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        plainTextData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptTextData);
        plainTextBytes = plainTextData;
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File f, FileOutputStream fos) throws Exception {
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = f.length();
            int processLen = 0;
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    fos.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File f, ByteArrayOutputStream plainTextByteArrayOutputStream) throws Exception {
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = f.length();
            int processLen = 0;
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    plainTextByteArrayOutputStream.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                plainTextByteArrayOutputStream.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static byte[] encrypt(Mechanism encryptAlg, Key key, byte[] sourceData, Session session) throws PKIException {
        try {
            return Base64.encode(session.encrypt(encryptAlg, key, sourceData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void encrypt(Mechanism encryptAlg, Key key, String sourceFilePath, String encryptFilePath, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            File f = new File(encryptFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            session.encrypt(encryptAlg, key, fis, fos);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
    }

    public static byte[] decrypt(Mechanism encryptAlg, Key key, byte[] encryptData, Session session) throws PKIException {
        try {
            return session.decrypt(encryptAlg, key, Base64.decode(encryptData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void decrypt(Mechanism encryptAlg, Key key, String encryptFilePath, String plainTextFilePath, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            File f = new File(plainTextFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            session.decrypt(encryptAlg, key, fis, fos);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrypt(Mechanism mechanism, Key key, String encryptFilePath, ByteArrayOutputStream plainTextByteArrayOutputStream, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            session.decrypt(mechanism, key, fis, plainTextByteArrayOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    private static byte[] pbeWithSM4Encrypt(boolean isEncrypted, String pass, byte[] data) throws PKIException {
        try {
            byte[] src = pass.getBytes("UTF8");
            byte[] hash = EncryptUtil.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private static byte[] doSM4WithNoPadding(boolean isEncrypt, byte[] input, byte[] key, byte[] iv) throws PKIException {
        try {
            CipherParameters param;
            BufferedBlockCipher cipher = null;
            if (iv != null) {
                param = new ParametersWithIV(new KeyParameter(key), iv);
                cipher = new BufferedBlockCipher(new CBCBlockCipher(new SM4Engine()));
                cipher.init(isEncrypt, param);
            } else {
                param = new KeyParameter(key);
                cipher = new BufferedBlockCipher(new SM4Engine());
                cipher.init(isEncrypt, param);
            }
            int len = cipher.getOutputSize(input.length);
            byte[] out = new byte[len];
            int len1 = cipher.processBytes(input, 0, input.length, out, 0);
            int len2 = cipher.doFinal(out, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] out2 = new byte[total];
                System.arraycopy(out, 0, out2, 0, total);
                return out2;
            }
            return out;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

