/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.signature.sm2;

import java.security.PublicKey;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2HashZValue;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.signature.sm2.SM2Signature;

public class SM2SignUtil {
    public static boolean verify(byte[] sourceData, byte[] userId, byte[] signature, PublicKey pubKey) throws PKIException {
        SM2Signature signer = new SM2Signature();
        if (sourceData == null || signature == null) {
            return false;
        }
        signer.initVerify(pubKey);
        SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
        byte[] temp = SM2HashZValue.getZa(sm2PubKey.getQ().getX().toBigInteger(), sm2PubKey.getQ().getY().toBigInteger(), userId);
        signer.update(temp, 0, temp.length);
        return signer.verify(signature, sourceData);
    }

    public static boolean verify(byte[] sourceData, byte[] signature, PublicKey pubKey) throws PKIException {
        SM2Signature signer = new SM2Signature();
        if (sourceData == null || signature == null) {
            return false;
        }
        signer.initVerify(pubKey);
        return signer.verify(signature, sourceData);
    }
}

