/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.signature.rsa;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.util.FileUtil;
import shaded.cfca.sadk.org.bouncycastle.crypto.Signer;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.signers.RSADigestSigner;
import shaded.cfca.sadk.system.global.FileAndBufferConfig;

public class RSASignUtil {
    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature) throws PKIException {
        if (sourceData == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        if ("SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
            return false;
        }
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        try {
            signer.update(sourceData, 0, sourceData.length);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature) throws Exception {
        if (sourceFilePath == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        BufferedInputStream bfis = new BufferedInputStream(new FileInputStream(sourceFilePath));
        try {
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                signer.update(buffer, 0, i);
            } while ((i = bfis.read(buffer)) != -1);
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath) throws Exception {
        RandomAccessFile bfis = null;
        FileOutputStream gen_fos = null;
        try {
            byte[] buffer;
            if (sourceFilePath == null || signature == null) {
                boolean bl = false;
                return bl;
            }
            Signer signer = RSASignUtil.getSigner(digestAlgorithm);
            RSAPublicKey publicKey = (RSAPublicKey)pubKey;
            RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
            signer.init(false, pubParameter);
            bfis = new RandomAccessFile(new File(sourceFilePath), "r");
            bfis.seek(startPos);
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                gen_fos = new FileOutputStream(generate_sourceFilePath);
            }
            if (dataLength > (long)FileAndBufferConfig.BIG_FILE_BUFFER) {
                int readLen;
                buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                    if (readTotalLen + (long)readLen <= dataLength) {
                        signer.update(buffer, 0, readLen);
                        FileUtil.writeBytesToFile(buffer, 0, readLen, gen_fos);
                        continue;
                    }
                    int left = (int)(dataLength - readTotalLen);
                    signer.update(buffer, 0, left);
                    FileUtil.writeBytesToFile(buffer, 0, left, gen_fos);
                    break;
                }
            } else {
                buffer = new byte[(int)dataLength];
                int i = bfis.read(buffer);
                signer.update(buffer, 0, i);
                FileUtil.writeBytesToFile(buffer, 0, i, gen_fos);
            }
            boolean bl = signer.verifySignature(signature);
            return bl;
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
            if (gen_fos != null) {
                gen_fos.close();
            }
        }
    }

    private static Signer getSigner(String digestAlgorithm) throws PKIException {
        if (digestAlgorithm.equals("MD5")) {
            return new RSADigestSigner(new MD5Digest());
        }
        if (digestAlgorithm.equals("SHA-1")) {
            return new RSADigestSigner(new SHA1Digest());
        }
        if (digestAlgorithm.equals("SHA-256")) {
            return new RSADigestSigner(new SHA256Digest());
        }
        if (digestAlgorithm.equals("SHA-512")) {
            return new RSADigestSigner(new SHA512Digest());
        }
        throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
    }

    private static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }
}

