/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.Target;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.TargetInformation;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.Targets;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.X509Extensions;
import shaded.cfca.sadk.org.bouncycastle.util.Selector;
import shaded.cfca.sadk.org.bouncycastle.x509.AttributeCertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.x509.AttributeCertificateIssuer;
import shaded.cfca.sadk.org.bouncycastle.x509.X509AttributeCertificate;

public class X509AttributeCertStoreSelector
implements Selector {
    private AttributeCertificateHolder holder;
    private AttributeCertificateIssuer issuer;
    private BigInteger serialNumber;
    private Date attributeCertificateValid;
    private X509AttributeCertificate attributeCert;
    private Collection targetNames = new HashSet();
    private Collection targetGroups = new HashSet();

    public boolean match(Object obj) {
        byte[] targetInfoExt;
        if (!(obj instanceof X509AttributeCertificate)) {
            return false;
        }
        X509AttributeCertificate attrCert = (X509AttributeCertificate)obj;
        if (this.attributeCert != null && !this.attributeCert.equals(attrCert)) {
            return false;
        }
        if (this.serialNumber != null && !attrCert.getSerialNumber().equals(this.serialNumber)) {
            return false;
        }
        if (this.holder != null && !attrCert.getHolder().equals(this.holder)) {
            return false;
        }
        if (this.issuer != null && !attrCert.getIssuer().equals(this.issuer)) {
            return false;
        }
        if (this.attributeCertificateValid != null) {
            try {
                attrCert.checkValidity(this.attributeCertificateValid);
            }
            catch (CertificateExpiredException e) {
                return false;
            }
            catch (CertificateNotYetValidException e) {
                return false;
            }
        }
        if (!(this.targetNames.isEmpty() && this.targetGroups.isEmpty() || (targetInfoExt = attrCert.getExtensionValue(X509Extensions.TargetInformation.getId())) == null)) {
            int j;
            Target[] targets;
            Targets t;
            int i;
            boolean found;
            TargetInformation targetinfo;
            try {
                targetinfo = TargetInformation.getInstance(new ASN1InputStream(((DEROctetString)DEROctetString.fromByteArray(targetInfoExt)).getOctets()).readObject());
            }
            catch (IOException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            Targets[] targetss = targetinfo.getTargetsObjects();
            if (!this.targetNames.isEmpty()) {
                found = false;
                block6: for (i = 0; i < targetss.length; ++i) {
                    t = targetss[i];
                    targets = t.getTargets();
                    for (j = 0; j < targets.length; ++j) {
                        if (!this.targetNames.contains(GeneralName.getInstance(targets[j].getTargetName()))) continue;
                        found = true;
                        continue block6;
                    }
                }
                if (!found) {
                    return false;
                }
            }
            if (!this.targetGroups.isEmpty()) {
                found = false;
                block8: for (i = 0; i < targetss.length; ++i) {
                    t = targetss[i];
                    targets = t.getTargets();
                    for (j = 0; j < targets.length; ++j) {
                        if (!this.targetGroups.contains(GeneralName.getInstance(targets[j].getTargetGroup()))) continue;
                        found = true;
                        continue block8;
                    }
                }
                if (!found) {
                    return false;
                }
            }
        }
        return true;
    }

    public Object clone() {
        X509AttributeCertStoreSelector sel = new X509AttributeCertStoreSelector();
        sel.attributeCert = this.attributeCert;
        sel.attributeCertificateValid = this.getAttributeCertificateValid();
        sel.holder = this.holder;
        sel.issuer = this.issuer;
        sel.serialNumber = this.serialNumber;
        sel.targetGroups = this.getTargetGroups();
        sel.targetNames = this.getTargetNames();
        return sel;
    }

    public X509AttributeCertificate getAttributeCert() {
        return this.attributeCert;
    }

    public void setAttributeCert(X509AttributeCertificate attributeCert) {
        this.attributeCert = attributeCert;
    }

    public Date getAttributeCertificateValid() {
        if (this.attributeCertificateValid != null) {
            return new Date(this.attributeCertificateValid.getTime());
        }
        return null;
    }

    public void setAttributeCertificateValid(Date attributeCertificateValid) {
        this.attributeCertificateValid = attributeCertificateValid != null ? new Date(attributeCertificateValid.getTime()) : null;
    }

    public AttributeCertificateHolder getHolder() {
        return this.holder;
    }

    public void setHolder(AttributeCertificateHolder holder) {
        this.holder = holder;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(AttributeCertificateIssuer issuer) {
        this.issuer = issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void addTargetName(GeneralName name) {
        this.targetNames.add(name);
    }

    public void addTargetName(byte[] name) throws IOException {
        this.addTargetName(GeneralName.getInstance(ASN1Primitive.fromByteArray(name)));
    }

    public void setTargetNames(Collection names) throws IOException {
        this.targetNames = this.extractGeneralNames(names);
    }

    public Collection getTargetNames() {
        return Collections.unmodifiableCollection(this.targetNames);
    }

    public void addTargetGroup(GeneralName group) {
        this.targetGroups.add(group);
    }

    public void addTargetGroup(byte[] name) throws IOException {
        this.addTargetGroup(GeneralName.getInstance(ASN1Primitive.fromByteArray(name)));
    }

    public void setTargetGroups(Collection names) throws IOException {
        this.targetGroups = this.extractGeneralNames(names);
    }

    public Collection getTargetGroups() {
        return Collections.unmodifiableCollection(this.targetGroups);
    }

    private Set extractGeneralNames(Collection names) throws IOException {
        if (names == null || names.isEmpty()) {
            return new HashSet();
        }
        HashSet temp = new HashSet();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof GeneralName) {
                temp.add(o);
                continue;
            }
            temp.add(GeneralName.getInstance(ASN1Primitive.fromByteArray((byte[])o)));
        }
        return temp;
    }
}

