/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.tsp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaCertStore;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import shaded.cfca.sadk.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import shaded.cfca.sadk.org.bouncycastle.tsp.TSPAlgorithms;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampRequestGenerator;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampResponseGenerator;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import shaded.cfca.sadk.org.bouncycastle.tsp.TimeStampTokenGenerator;
import shaded.cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import shaded.cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedDataGenerator;
import shaded.cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedDataParser;
import shaded.cfca.sadk.org.bouncycastle.tsp.test.SHA1DigestCalculator;
import shaded.cfca.sadk.org.bouncycastle.tsp.test.TSPTestUtil;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGeneratorTest
extends TestCase {
    BouncyCastleProvider bouncyCastleProvider;
    CMSTimeStampedDataGenerator cmsTimeStampedDataGenerator = null;
    String fileInput = "FileDaFirmare.data";
    byte[] baseData;

    protected void setUp() throws Exception {
        int ch;
        this.bouncyCastleProvider = new BouncyCastleProvider();
        if (Security.getProvider(this.bouncyCastleProvider.getName()) == null) {
            Security.addProvider(this.bouncyCastleProvider);
        }
        this.cmsTimeStampedDataGenerator = new CMSTimeStampedDataGenerator();
        ByteArrayOutputStream origStream = new ByteArrayOutputStream();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.fileInput);
        while ((ch = in.read()) >= 0) {
            origStream.write(ch);
        }
        origStream.close();
        this.baseData = origStream.toByteArray();
    }

    protected void tearDown() throws Exception {
        this.cmsTimeStampedDataGenerator = null;
        Security.removeProvider(this.bouncyCastleProvider.getName());
    }

    public void testGenerate() throws Exception {
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algOID = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1");
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algOID));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        TimeStampToken timeStampToken = this.createTimeStampToken(hashCalculator.getDigest(), NISTObjectIdentifiers.id_sha256);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        for (int i = 0; i < 3; ++i) {
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, NISTObjectIdentifiers.id_sha256);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = cmsTimeStampedData.getMessageImprintDigestCalculator(newCalculatorProvider);
        CMSTimeStampedData newCMSTimeStampedData = new CMSTimeStampedData(timeStampedData);
        byte[] newContent = newCMSTimeStampedData.getContent();
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual(newContent, this.baseData));
        imprintCalculator.getOutputStream().write(newContent);
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTimeStampedData.getTimeStampTokens();
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"TimeStampToken expected and verified are different", (int)4, (int)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            cmsTimeStampedData.validate(newCalculatorProvider, digest, tokens[i]);
        }
    }

    public void testGenerateWithMetadata() throws Exception {
        this.cmsTimeStampedDataGenerator.setMetaData(true, this.fileInput, "TXT");
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algOID = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1");
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algOID));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        TimeStampToken timeStampToken = this.createTimeStampToken(hashCalculator.getDigest(), NISTObjectIdentifiers.id_sha256);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        for (int i = 0; i <= 3; ++i) {
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, NISTObjectIdentifiers.id_sha256);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        this.metadataCheck(timeStampedData);
        this.metadataParserCheck(timeStampedData);
    }

    public void testGenerateWithMetadataAndDifferentAlgorithmIdentifier() throws Exception {
        this.cmsTimeStampedDataGenerator.setMetaData(true, this.fileInput, "TXT");
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algIdentifier = NISTObjectIdentifiers.id_sha224;
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algIdentifier));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        byte[] requestData = hashCalculator.getDigest();
        TimeStampToken timeStampToken = this.createTimeStampToken(requestData, algIdentifier);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        for (int i = 0; i <= 3; ++i) {
            switch (i) {
                case 0: {
                    algIdentifier = NISTObjectIdentifiers.id_sha224;
                    break;
                }
                case 1: {
                    algIdentifier = NISTObjectIdentifiers.id_sha256;
                    break;
                }
                case 2: {
                    algIdentifier = NISTObjectIdentifiers.id_sha384;
                    break;
                }
                case 3: {
                    algIdentifier = NISTObjectIdentifiers.id_sha512;
                }
            }
            hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algIdentifier));
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, algIdentifier);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        this.metadataCheck(timeStampedData);
        this.metadataParserCheck(timeStampedData);
    }

    private void metadataCheck(byte[] timeStampedData) throws Exception {
        CMSTimeStampedData cmsTspData = new CMSTimeStampedData(timeStampedData);
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = cmsTspData.getMessageImprintDigestCalculator(newCalculatorProvider);
        byte[] newContent = cmsTspData.getContent();
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual(newContent, this.baseData));
        imprintCalculator.getOutputStream().write(newContent);
        CMSTimeStampedDataGeneratorTest.assertEquals((String)this.fileInput, (String)cmsTspData.getFileName());
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"TXT", (String)cmsTspData.getMediaType());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTspData.getTimeStampTokens();
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"TimeStampToken expected and verified are different", (int)5, (int)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            cmsTspData.validate(newCalculatorProvider, digest, tokens[i]);
        }
    }

    private void metadataParserCheck(byte[] timeStampedData) throws Exception {
        CMSTimeStampedDataParser cmsTspData = new CMSTimeStampedDataParser(timeStampedData);
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        InputStream input = cmsTspData.getContent();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Streams.pipeAll(input, bOut);
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual(bOut.toByteArray(), this.baseData));
        DigestCalculator imprintCalculator = cmsTspData.getMessageImprintDigestCalculator(newCalculatorProvider);
        Streams.pipeAll(new ByteArrayInputStream(bOut.toByteArray()), imprintCalculator.getOutputStream());
        CMSTimeStampedDataGeneratorTest.assertEquals((String)this.fileInput, (String)cmsTspData.getFileName());
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"TXT", (String)cmsTspData.getMediaType());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTspData.getTimeStampTokens();
        CMSTimeStampedDataGeneratorTest.assertEquals((String)"TimeStampToken expected and verified are different", (int)5, (int)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            cmsTspData.validate(newCalculatorProvider, digest, tokens[i]);
        }
    }

    private TimeStampToken createTimeStampToken(byte[] hash, ASN1ObjectIdentifier hashAlg) throws Exception {
        String algorithmName = null;
        if (hashAlg.equals(NISTObjectIdentifiers.id_sha224)) {
            algorithmName = "SHA224withRSA";
        } else if (hashAlg.equals(NISTObjectIdentifiers.id_sha256)) {
            algorithmName = "SHA256withRSA";
        } else if (hashAlg.equals(NISTObjectIdentifiers.id_sha384)) {
            algorithmName = "SHA384withRSA";
        } else if (hashAlg.equals(NISTObjectIdentifiers.id_sha512)) {
            algorithmName = "SHA512withRSA";
        }
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = TSPTestUtil.makeKeyPair();
        X509Certificate signCert = TSPTestUtil.makeCACertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = TSPTestUtil.makeKeyPair();
        X509Certificate cert = TSPTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        PrivateKey privateKey = origKP.getPrivate();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build(algorithmName, privateKey, cert), new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(hashAlg, hash);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        return tsResp.getTimeStampToken();
    }
}

