/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import shaded.cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceKobaraImaiCipher;
import shaded.cfca.sadk.org.bouncycastle.pqc.crypto.mceliece.McElieceKobaraImaiDigestCipher;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class McElieceKobaraImaiCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    public String getName() {
        return "McElieceKobaraImai";
    }

    public void performTest() {
        int numPassesKPG = 1;
        int numPassesEncDec = 10;
        Random rand = new Random();
        for (int j = 0; j < numPassesKPG; ++j) {
            McElieceCCA2Parameters params = new McElieceCCA2Parameters();
            McElieceCCA2KeyPairGenerator mcElieceCCA2KeyGen = new McElieceCCA2KeyPairGenerator();
            McElieceCCA2KeyGenerationParameters genParam = new McElieceCCA2KeyGenerationParameters(this.keyRandom, params);
            mcElieceCCA2KeyGen.init(genParam);
            AsymmetricCipherKeyPair pair = mcElieceCCA2KeyGen.generateKeyPair();
            ParametersWithRandom param = new ParametersWithRandom(pair.getPublic(), this.keyRandom);
            SHA256Digest msgDigest = new SHA256Digest();
            McElieceKobaraImaiDigestCipher mcElieceKobaraImaiDigestCipher = new McElieceKobaraImaiDigestCipher(new McElieceKobaraImaiCipher(), msgDigest);
            for (int k = 1; k <= numPassesEncDec; ++k) {
                System.out.println("############### test: " + k);
                mcElieceKobaraImaiDigestCipher.init(true, param);
                int mLength = (rand.nextInt() & 0x1F) + 1;
                byte[] mBytes = new byte[mLength];
                rand.nextBytes(mBytes);
                mcElieceKobaraImaiDigestCipher.update(mBytes, 0, mBytes.length);
                byte[] enc = mcElieceKobaraImaiDigestCipher.messageEncrypt();
                mcElieceKobaraImaiDigestCipher.init(false, pair.getPrivate());
                byte[] constructedmessage = mcElieceKobaraImaiDigestCipher.messageDecrypt(enc);
                msgDigest.update(mBytes, 0, mBytes.length);
                byte[] hash = new byte[msgDigest.getDigestSize()];
                msgDigest.doFinal(hash, 0);
                boolean verified = true;
                for (int i = 0; i < hash.length; ++i) {
                    verified = verified && hash[i] == constructedmessage[i];
                }
                if (!verified) {
                    this.fail("en/decryption fails");
                    continue;
                }
                System.out.println("test okay");
                System.out.println();
            }
        }
    }

    public static void main(String[] args) {
        McElieceKobaraImaiCipherTest.runTest(new McElieceKobaraImaiCipherTest());
    }
}

