/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.pkcs.bc;

import java.io.InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.io.CipherInputStream;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.operator.GenericKey;
import shaded.cfca.sadk.org.bouncycastle.operator.InputDecryptor;
import shaded.cfca.sadk.org.bouncycastle.operator.InputDecryptorProvider;
import shaded.cfca.sadk.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

