/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.math.ec;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.math.ec.AbstractECMultiplier;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import shaded.cfca.sadk.org.bouncycastle.math.ec.LongArray;
import shaded.cfca.sadk.org.bouncycastle.math.ec.WNafPreCompInfo;
import shaded.cfca.sadk.org.bouncycastle.math.ec.WNafUtil;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECPoint[] table;
        int n;
        int zeroes;
        int digit;
        int wi;
        int width = Math.max(2, Math.min(16, this.getWindowSize(k.bitLength())));
        WNafPreCompInfo wnafPreCompInfo = WNafUtil.precompute(p, width, true);
        ECPoint[] preComp = wnafPreCompInfo.getPreComp();
        ECPoint[] preCompNeg = wnafPreCompInfo.getPreCompNeg();
        int[] wnaf = WNafUtil.generateCompactWindowNaf(width, k);
        ECPoint R = p.getCurve().getInfinity();
        int i = wnaf.length;
        if (i > 1) {
            wi = wnaf[--i];
            digit = wi >> 16;
            zeroes = wi & 0xFFFF;
            n = Math.abs(digit);
            ECPoint[] eCPointArray = table = digit < 0 ? preCompNeg : preComp;
            if (n << 2 < 1 << width) {
                byte highest = LongArray.bitLengths[n];
                int scale = width - highest;
                int lowBits = n ^ 1 << highest - 1;
                int i1 = (1 << width - 1) - 1;
                int i2 = (lowBits << scale) + 1;
                R = table[i1 >>> 1].add(table[i2 >>> 1]);
                zeroes -= scale;
            } else {
                R = table[n >>> 1];
            }
            R = R.timesPow2(zeroes);
        }
        while (i > 0) {
            wi = wnaf[--i];
            digit = wi >> 16;
            zeroes = wi & 0xFFFF;
            n = Math.abs(digit);
            table = digit < 0 ? preCompNeg : preComp;
            ECPoint r = table[n >>> 1];
            R = R.twicePlus(r);
            R = R.timesPow2(zeroes);
        }
        return R;
    }

    protected int getWindowSize(int bits) {
        return WNafUtil.getWindowSize(bits);
    }
}

