/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.SecureRandom;
import junit.framework.TestCase;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsClientProtocol;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsServerProtocol;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.NetworkInputStream;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.NetworkOutputStream;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestClientImpl;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestConfig;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestServerImpl;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.io.Streams;

public class TlsTestCase
extends TestCase {
    protected final TlsTestConfig config;

    private static void checkTLSVersion(ProtocolVersion version) {
        if (version != null && !version.isTLS()) {
            throw new IllegalStateException("Non-TLS version");
        }
    }

    public TlsTestCase(TlsTestConfig config, String name) {
        TlsTestCase.checkTLSVersion(config.clientMinimumVersion);
        TlsTestCase.checkTLSVersion(config.clientOfferVersion);
        TlsTestCase.checkTLSVersion(config.serverMaximumVersion);
        TlsTestCase.checkTLSVersion(config.serverMinimumVersion);
        this.config = config;
        this.setName(name);
    }

    protected void runTest() throws Throwable {
        SecureRandom secureRandom = new SecureRandom();
        PipedInputStream clientRead = new PipedInputStream();
        PipedInputStream serverRead = new PipedInputStream();
        PipedOutputStream clientWrite = new PipedOutputStream(serverRead);
        PipedOutputStream serverWrite = new PipedOutputStream(clientRead);
        NetworkInputStream clientNetIn = new NetworkInputStream(clientRead);
        NetworkInputStream serverNetIn = new NetworkInputStream(serverRead);
        NetworkOutputStream clientNetOut = new NetworkOutputStream(clientWrite);
        NetworkOutputStream serverNetOut = new NetworkOutputStream(serverWrite);
        TlsClientProtocol clientProtocol = new TlsClientProtocol(clientNetIn, clientNetOut, secureRandom);
        TlsServerProtocol serverProtocol = new TlsServerProtocol(serverNetIn, serverNetOut, secureRandom);
        TlsTestClientImpl clientImpl = new TlsTestClientImpl(this.config);
        TlsTestServerImpl serverImpl = new TlsTestServerImpl(this.config);
        ServerThread serverThread = new ServerThread(serverProtocol, serverImpl);
        serverThread.start();
        Exception caught = null;
        try {
            clientProtocol.connect(clientImpl);
            int length = 1000;
            byte[] data = new byte[length];
            secureRandom.nextBytes(data);
            OutputStream output = clientProtocol.getOutputStream();
            output.write(data);
            byte[] echo = new byte[data.length];
            int count = Streams.readFully(clientProtocol.getInputStream(), echo);
            TlsTestCase.assertEquals((int)count, (int)data.length);
            TlsTestCase.assertTrue((boolean)Arrays.areEqual(data, echo));
            output.close();
        }
        catch (Exception e) {
            caught = e;
            this.logException(caught);
        }
        serverThread.allowExit();
        serverThread.join();
        TlsTestCase.assertTrue((String)"Client InputStream not closed", (boolean)clientNetIn.isClosed());
        TlsTestCase.assertTrue((String)"Client OutputStream not closed", (boolean)clientNetOut.isClosed());
        TlsTestCase.assertTrue((String)"Server InputStream not closed", (boolean)serverNetIn.isClosed());
        TlsTestCase.assertTrue((String)"Server OutputStream not closed", (boolean)serverNetOut.isClosed());
        TlsTestCase.assertEquals((String)"Client fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)clientImpl.firstFatalAlertConnectionEnd);
        TlsTestCase.assertEquals((String)"Server fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)serverImpl.firstFatalAlertConnectionEnd);
        TlsTestCase.assertEquals((String)"Client fatal alert description", (short)this.config.expectFatalAlertDescription, (short)clientImpl.firstFatalAlertDescription);
        TlsTestCase.assertEquals((String)"Server fatal alert description", (short)this.config.expectFatalAlertDescription, (short)serverImpl.firstFatalAlertDescription);
        if (this.config.expectFatalAlertConnectionEnd == -1) {
            TlsTestCase.assertNull((String)"Unexpected client exception", (Object)caught);
            TlsTestCase.assertNull((String)"Unexpected server exception", (Object)serverThread.caught);
        }
    }

    protected void logException(Exception e) {
    }

    class ServerThread
    extends Thread {
        protected final TlsServerProtocol serverProtocol;
        protected final TlsTestServerImpl serverImpl;
        boolean canExit = false;
        Exception caught = null;

        ServerThread(TlsServerProtocol serverProtocol, TlsTestServerImpl serverImpl) {
            this.serverProtocol = serverProtocol;
            this.serverImpl = serverImpl;
        }

        synchronized void allowExit() {
            this.canExit = true;
            this.notifyAll();
        }

        public void run() {
            try {
                this.serverProtocol.accept(this.serverImpl);
                Streams.pipeAll(this.serverProtocol.getInputStream(), this.serverProtocol.getOutputStream());
                this.serverProtocol.close();
            }
            catch (Exception e) {
                this.caught = e;
                TlsTestCase.this.logException(this.caught);
            }
            this.waitExit();
        }

        protected synchronized void waitExit() {
            while (!this.canExit) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

