/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls;

import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.prng.DigestRandomGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.prng.RandomGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SecurityParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsSession;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import shaded.cfca.sadk.org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private RandomGenerator nonceRandom;
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    AbstractTlsContext(SecureRandom secureRandom, SecurityParameters securityParameters) {
        secureRandom.setSeed(AbstractTlsContext.nextCounterValue());
        secureRandom.setSeed(Times.nanoTime());
        this.nonceRandom = new DigestRandomGenerator(TlsUtils.createHash((short)4));
        this.nonceRandom.addSeedMaterial(secureRandom.generateSeed(32));
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
    }

    public RandomGenerator getNonceRandomGenerator() {
        return this.nonceRandom;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public TlsSession getResumableSession() {
        return this.session;
    }

    void setResumableSession(TlsSession session) {
        this.session = session;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = this.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, seed, seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, sp.getMasterSecret(), asciiLabel, seed, length);
    }
}

