/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.NaccacheSternEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.NaccacheSternKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class NaccacheSternTest
extends SimpleTest {
    static final boolean debug = false;
    static final NaccacheSternEngine cryptEng = new NaccacheSternEngine();
    static final NaccacheSternEngine decryptEng = new NaccacheSternEngine();
    static final BigInteger a;
    static final BigInteger u1;
    static final BigInteger u2;
    static final BigInteger u3;
    static final BigInteger b;
    static final BigInteger v1;
    static final BigInteger v2;
    static final BigInteger v3;
    static final BigInteger ONE;
    static final BigInteger TWO;
    static final BigInteger sigma;
    static final BigInteger p;
    static final BigInteger q;
    static final BigInteger n;
    static final BigInteger phi_n;
    static final BigInteger g;
    static final Vector smallPrimes;
    static final String input = "4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
    static final BigInteger paperTest;
    static final String edgeInput = "ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";

    public String getName() {
        return "NaccacheStern";
    }

    public void performTest() {
        smallPrimes.addElement(u1);
        smallPrimes.addElement(u2);
        smallPrimes.addElement(u3);
        smallPrimes.addElement(v1);
        smallPrimes.addElement(v2);
        smallPrimes.addElement(v3);
        NaccacheSternKeyParameters pubParameters = new NaccacheSternKeyParameters(false, g, n, sigma.bitLength());
        NaccacheSternPrivateKeyParameters privParameters = new NaccacheSternPrivateKeyParameters(g, n, sigma.bitLength(), smallPrimes, phi_n);
        AsymmetricCipherKeyPair pair = new AsymmetricCipherKeyPair(pubParameters, privParameters);
        cryptEng.init(true, pair.getPublic());
        decryptEng.init(false, pair.getPrivate());
        byte[] data = paperTest.toByteArray();
        if (!new BigInteger(data).equals(new BigInteger(this.enDeCrypt(data)))) {
            this.fail("failed NaccacheStern paper test");
        }
        NaccacheSternKeyGenerationParameters genParam = new NaccacheSternKeyGenerationParameters(new SecureRandom(), 768, 8, 30, false);
        NaccacheSternKeyPairGenerator pGen = new NaccacheSternKeyPairGenerator();
        pGen.init(genParam);
        pair = pGen.generateKeyPair();
        if (((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() < 768) {
            System.out.println("FAILED: key size is <786 bit, exactly " + ((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() + " bit");
            this.fail("failed key generation (768) length test");
        }
        cryptEng.init(true, pair.getPublic());
        decryptEng.init(false, pair.getPrivate());
        data = Hex.decode(input);
        if (!new BigInteger(1, data).equals(new BigInteger(1, this.enDeCrypt(data)))) {
            this.fail("failed encryption decryption (" + genParam.getStrength() + ") basic test");
        }
        if (!new BigInteger(1, data = Hex.decode(edgeInput)).equals(new BigInteger(1, this.enDeCrypt(data)))) {
            this.fail("failed encryption decryption (" + genParam.getStrength() + ") edgeInput test");
        }
        try {
            new NaccacheSternEngine().processBlock(new byte[]{1}, 0, 1);
            this.fail("failed initialisation check");
        }
        catch (IllegalStateException e) {
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed initialisation check");
        }
    }

    private byte[] enDeCrypt(byte[] input) {
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, data.length);
        try {
            data = cryptEng.processData(data);
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed - exception " + e.toString() + "\n" + e.getMessage());
        }
        try {
            data = decryptEng.processData(data);
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed - exception " + e.toString() + "\n" + e.getMessage());
        }
        return data;
    }

    public static void main(String[] args) {
        NaccacheSternTest.runTest(new NaccacheSternTest());
    }

    static {
        cryptEng.setDebug(false);
        decryptEng.setDebug(false);
        a = BigInteger.valueOf(101L);
        u1 = BigInteger.valueOf(3L);
        u2 = BigInteger.valueOf(5L);
        u3 = BigInteger.valueOf(7L);
        b = BigInteger.valueOf(191L);
        v1 = BigInteger.valueOf(11L);
        v2 = BigInteger.valueOf(13L);
        v3 = BigInteger.valueOf(17L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        sigma = u1.multiply(u2).multiply(u3).multiply(v1).multiply(v2).multiply(v3);
        p = TWO.multiply(a).multiply(u1).multiply(u2).multiply(u3).add(ONE);
        q = TWO.multiply(b).multiply(v1).multiply(v2).multiply(v3).add(ONE);
        n = p.multiply(q);
        phi_n = p.subtract(ONE).multiply(q.subtract(ONE));
        g = BigInteger.valueOf(131L);
        smallPrimes = new Vector();
        paperTest = BigInteger.valueOf(202L);
    }
}

