/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms.test;

import java.math.BigInteger;
import java.security.cert.X509CertSelector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import shaded.cfca.sadk.org.bouncycastle.cms.KeyTransRecipientId;
import shaded.cfca.sadk.org.bouncycastle.cms.SignerId;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaSelectorConverter;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class ConverterTest
extends TestCase {
    public void testSignerIdConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        SignerId sid1 = new SignerId(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(sid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        SignerId sid2 = toSelector.getSignerId(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new SignerId(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(sid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertNull((Object)conv.getSubjectKeyIdentifier());
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)sid1.getSerialNumber());
        sid2 = toSelector.getSignerId(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
        sid1 = new SignerId(new byte[20]);
        conv = converter.getCertSelector(sid1);
        ConverterTest.assertNull((Object)conv.getIssuerAsString());
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertNull((Object)conv.getSerialNumber());
        sid2 = toSelector.getSignerId(conv);
        ConverterTest.assertEquals((Object)sid1, (Object)sid2);
    }

    public void testRecipientIdConversion() throws Exception {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        JcaSelectorConverter toSelector = new JcaSelectorConverter();
        KeyTransRecipientId ktid1 = new KeyTransRecipientId(new X500Name("CN=Test"), BigInteger.valueOf(1L), new byte[20]);
        X509CertSelector conv = converter.getCertSelector(ktid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)ktid1.getSerialNumber());
        KeyTransRecipientId ktid2 = toSelector.getKeyTransRecipientId(conv);
        ConverterTest.assertEquals((Object)ktid1, (Object)ktid2);
        ktid1 = new KeyTransRecipientId(new X500Name("CN=Test"), BigInteger.valueOf(1L));
        conv = converter.getCertSelector(ktid1);
        ConverterTest.assertTrue((boolean)conv.getIssuerAsString().equals("CN=Test"));
        ConverterTest.assertNull((Object)conv.getSubjectKeyIdentifier());
        ConverterTest.assertEquals((Object)conv.getSerialNumber(), (Object)ktid1.getSerialNumber());
        ktid2 = toSelector.getKeyTransRecipientId(conv);
        ConverterTest.assertEquals((Object)ktid1, (Object)ktid2);
        ktid1 = new KeyTransRecipientId(new byte[20]);
        conv = converter.getCertSelector(ktid1);
        ConverterTest.assertNull((Object)conv.getIssuerAsString());
        ConverterTest.assertTrue((boolean)Arrays.areEqual(conv.getSubjectKeyIdentifier(), new DEROctetString(new byte[20]).getEncoded()));
        ConverterTest.assertNull((Object)conv.getSerialNumber());
        ktid2 = toSelector.getKeyTransRecipientId(conv);
        ConverterTest.assertEquals((Object)ktid1, (Object)ktid2);
    }

    public static Test suite() throws Exception {
        return new TestSuite(ConverterTest.class);
    }
}

