/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSet;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cert.X509AttributeCertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaCRLStore;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaCertStore;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSAbsentContent;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSProcessable;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSProcessableByteArray;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignedDataGenerator;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignedDataParser;
import shaded.cfca.sadk.org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import shaded.cfca.sadk.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import shaded.cfca.sadk.org.bouncycastle.cms.SignerId;
import shaded.cfca.sadk.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.SignerInformation;
import shaded.cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import shaded.cfca.sadk.org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import shaded.cfca.sadk.org.bouncycastle.cms.test.CMSTestSetup;
import shaded.cfca.sadk.org.bouncycastle.cms.test.CMSTestUtil;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.util.PrivateKeyFactory;
import shaded.cfca.sadk.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.BufferingContentSigner;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentSigner;
import shaded.cfca.sadk.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import shaded.cfca.sadk.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import shaded.cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.util.CollectionStore;
import shaded.cfca.sadk.org.bouncycastle.util.Store;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Base64;
import shaded.cfca.sadk.org.bouncycastle.util.io.Streams;

public class BcSignedDataTest
extends TestCase {
    private static final String BC = "BC";
    boolean DEBUG = true;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static KeyPair _signEcDsaKP;
    private static X509Certificate _signEcDsaCert;
    private static KeyPair _signEcGostKP;
    private static X509Certificate _signEcGostCert;
    private static KeyPair _signDsaKP;
    private static X509Certificate _signDsaCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static X509CRL _signCrl;
    private static boolean _initialised;
    private byte[] disorderedMessage = Base64.decode("SU9fc3RkaW5fdXNlZABfX2xpYmNfc3RhcnRfbWFpbgBnZXRob3N0aWQAX19nbW9uX3M=");
    private byte[] disorderedSet = Base64.decode("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");
    public static byte[] xtraCounterSig;
    byte[] noSignedAttrSample2 = Base64.decode("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");

    public BcSignedDataTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)BcSignedDataTest.class);
    }

    public static Test suite() throws Exception {
        BcSignedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(BcSignedDataTest.class));
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            if (Security.getProvider(BC) == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            _origDN = "O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _origKP, _origDN);
            _signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _origKP, _origDN);
            _signDsaKP = CMSTestUtil.makeDsaKeyPair();
            _signDsaCert = CMSTestUtil.makeCertificate(_signDsaKP, _signDN, _origKP, _origDN);
            _signEcDsaKP = CMSTestUtil.makeEcDsaKeyPair();
            _signEcDsaCert = CMSTestUtil.makeCertificate(_signEcDsaKP, _signDN, _origKP, _origDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _signCrl = CMSTestUtil.makeCrl(_signKP);
        }
    }

    private void verifyRSASignatures(CMSSignedData s, byte[] contentDigest) throws Exception {
        Store certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new BcRSASignerInfoVerifierBuilder(new DefaultCMSSignatureAlgorithmNameGenerator(), new DefaultSignatureAlgorithmIdentifierFinder(), new DefaultDigestAlgorithmIdentifierFinder(), new BcDigestCalculatorProvider()).build(cert)));
            if (contentDigest == null) continue;
            BcSignedDataTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
    }

    private void verifySignatures(CMSSignedData s, byte[] contentDigest) throws Exception {
        Store certStore = s.getCertificates();
        Store crlStore = s.getCRLs();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            if (contentDigest == null) continue;
            BcSignedDataTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
        Collection certColl = certStore.getMatches(null);
        Collection crlColl = crlStore.getMatches(null);
        BcSignedDataTest.assertEquals((int)certColl.size(), (int)s.getCertificates().getMatches(null).size());
        BcSignedDataTest.assertEquals((int)crlColl.size(), (int)s.getCRLs().getMatches(null).size());
    }

    private void verifySignatures(CMSSignedData s) throws Exception {
        this.verifySignatures(s, null);
    }

    public void testDetachedVerification() throws Exception {
        byte[] data = "Hello World!".getBytes();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digProvider);
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        ContentSigner md5Signer = new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(sha1Signer, _origCert));
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(md5Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1", BC);
        MessageDigest md5 = MessageDigest.getInstance("MD5", BC);
        HashMap<ASN1ObjectIdentifier, byte[]> hashes = new HashMap<ASN1ObjectIdentifier, byte[]>();
        byte[] sha1Hash = sha1.digest(data);
        byte[] md5Hash = md5.digest(data);
        hashes.put(CMSAlgorithm.SHA1, sha1Hash);
        hashes.put(CMSAlgorithm.MD5, md5Hash);
        s = new CMSSignedData(hashes, s.getEncoded());
        this.verifySignatures(s, null);
    }

    public void testDetachedVerificationWithBufferingContentSigner() throws Exception {
        byte[] data = "Hello World!".getBytes();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digProvider = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digProvider);
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        ContentSigner md5Signer = new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build((ContentSigner)new BufferingContentSigner(sha1Signer), _origCert));
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build((ContentSigner)new BufferingContentSigner(md5Signer), _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1", BC);
        MessageDigest md5 = MessageDigest.getInstance("MD5", BC);
        HashMap<ASN1ObjectIdentifier, byte[]> hashes = new HashMap<ASN1ObjectIdentifier, byte[]>();
        byte[] sha1Hash = sha1.digest(data);
        byte[] md5Hash = md5.digest(data);
        hashes.put(CMSAlgorithm.SHA1, sha1Hash);
        hashes.put(CMSAlgorithm.MD5, md5Hash);
        s = new CMSSignedData(hashes, s.getEncoded());
        this.verifySignatures(s, null);
    }

    public void testSHA1AndMD5WithRSAEncapsulatedRepeated() throws Exception {
        X509CertificateHolder cert;
        Iterator certIt;
        Collection certCollection;
        SignerInformation signer;
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        Store certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate()), _origCert));
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(digCalcProv).build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate()), _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        BcSignedDataTest.assertEquals((int)2, (int)signers.size());
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        SignerId sid = null;
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            certCollection = certs.getMatches(signer.getSID());
            certIt = certCollection.iterator();
            cert = (X509CertificateHolder)certIt.next();
            sid = signer.getSID();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(signer.getDigestAlgOID());
            AttributeTable table = signer.getSignedAttributes();
            Attribute hash = table.get(CMSAttributes.messageDigest);
            BcSignedDataTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        }
        c = signers.getSigners(sid);
        BcSignedDataTest.assertEquals((int)2, (int)c.size());
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate(msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certs = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        BcSignedDataTest.assertEquals((int)2, (int)c.size());
        while (it.hasNext()) {
            signer = (SignerInformation)it.next();
            certCollection = certs.getMatches(signer.getSID());
            certIt = certCollection.iterator();
            cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    public void testSHA1WithRSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg, false);
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSANoAttributesSimple() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSimpleSignerInfoGeneratorBuilder builder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg, false);
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSHA1WithRSAViaConfig() throws Exception {
        CMSSignedData s;
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        TestCMSSignatureAlgorithmNameGenerator sigAlgNameGen = new TestCMSSignatureAlgorithmNameGenerator();
        sigAlgNameGen.setEncryptionAlgorithmMapping(PKCSObjectIdentifiers.rsaEncryption, "XXXX");
        sigAlgNameGen.setDigestAlgorithmMapping(OIWObjectIdentifiers.idSHA1, "YYYY");
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        try {
            s = gen.generate(msg, false);
        }
        catch (CMSException e) {
            if (!e.getMessage().startsWith("no such algorithm: YYYYwithXXXX")) {
                throw e;
            }
        }
        finally {
            sigAlgNameGen.setEncryptionAlgorithmMapping(PKCSObjectIdentifiers.rsaEncryption, "RSA");
            sigAlgNameGen.setDigestAlgorithmMapping(OIWObjectIdentifiers.idSHA1, "SHA1");
        }
        s = gen.generate(msg, false);
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAAndAttributeTableSimple() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(attr);
        SignerInfoGeneratorBuilder builder = new SignerInfoGeneratorBuilder(new BcDigestCalculatorProvider()).setSignedAttributeGenerator(new DefaultSignedAttributeTableGenerator(new AttributeTable(v)));
        AlgorithmIdentifier sha1withRSA = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
        gen.addSignerInfoGenerator(builder.build(new BcRSAContentSignerBuilder(sha1withRSA, new DefaultDigestAlgorithmIdentifierFinder().find(sha1withRSA)).build(PrivateKeyFactory.createKey(_origKP.getPrivate().getEncoded())), new JcaX509CertificateHolder(_origCert)));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAAndAttributeTable() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(attr);
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setSignedAttributeGenerator(new DefaultSignedAttributeTableGenerator(new AttributeTable(v)));
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testLwSHA1WithRSAAndAttributeTable() throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Attribute attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(md.digest("Hello world!".getBytes()))));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(attr);
        AsymmetricKeyParameter privKey = PrivateKeyFactory.createKey(_origKP.getPrivate().getEncoded());
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        BcRSAContentSignerBuilder contentSignerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
        gen.addSignerInfoGenerator(new SignerInfoGeneratorBuilder(new BcDigestCalculatorProvider()).setSignedAttributeGenerator(new DefaultSignedAttributeTableGenerator(new AttributeTable(v))).build(contentSignerBuilder.build(privKey), new JcaX509CertificateHolder(_origCert)));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(new CMSAbsentContent(), false);
        s = new CMSSignedData((CMSProcessable)msg, s.getEncoded());
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
        this.verifyRSASignatures(s, md.digest("Hello world!".getBytes()));
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA1withRSA");
    }

    public void testSHA1WithRSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signKP, _signCert, "SHA1withRSA");
    }

    public void testSHA1WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA1withRSAandMGF1");
    }

    public void testSHA224WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA224withRSAandMGF1");
    }

    public void testSHA256WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA256withRSAandMGF1");
    }

    public void testSHA384WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA384withRSAandMGF1");
    }

    public void testSHA224WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA224withRSA");
    }

    public void testSHA256WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "SHA256withRSA");
    }

    public void testRIPEMD128WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD128withRSA");
    }

    public void testRIPEMD160WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD160withRSA");
    }

    public void testRIPEMD256WithRSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signKP, _signCert, "RIPEMD256withRSA");
    }

    public void testECDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA1withECDSA");
    }

    public void testECDSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signEcDsaKP, _signEcDsaCert, "SHA1withECDSA");
    }

    public void testECDSASHA224Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA224withECDSA");
    }

    public void testECDSASHA256Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA256withECDSA");
    }

    public void testECDSASHA384Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA384withECDSA");
    }

    public void testECDSASHA512Encapsulated() throws Exception {
        this.encapsulatedTest(_signEcDsaKP, _signEcDsaCert, "SHA512withECDSA");
    }

    public void testECDSASHA512EncapsulatedWithKeyFactoryAsEC() throws Exception {
        X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(_signEcDsaKP.getPublic().getEncoded());
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(_signEcDsaKP.getPrivate().getEncoded());
        KeyFactory keyFact = KeyFactory.getInstance("EC", BC);
        KeyPair kp = new KeyPair(keyFact.generatePublic(pubSpec), keyFact.generatePrivate(privSpec));
        this.encapsulatedTest(kp, _signEcDsaCert, "SHA512withECDSA");
    }

    public void testDSAEncapsulated() throws Exception {
        this.encapsulatedTest(_signDsaKP, _signDsaCert, "SHA1withDSA");
    }

    public void testDSAEncapsulatedSubjectKeyID() throws Exception {
        this.subjectKeyIDTest(_signDsaKP, _signDsaCert, "SHA1withDSA");
    }

    public void testSHA1WithRSACounterSignature() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        JcaCertStore certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_signKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _signCert));
        gen.addCertificates(certStore);
        gen.addCRLs(crlStore);
        CMSSignedData s = gen.generate(msg, true);
        SignerInformation origSigner = (SignerInformation)s.getSignerInfos().getSigners().toArray()[0];
        SignerInformationStore counterSigners1 = gen.generateCounterSigners(origSigner);
        SignerInformationStore counterSigners2 = gen.generateCounterSigners(origSigner);
        SignerInformation signer1 = SignerInformation.addCounterSigners(origSigner, counterSigners1);
        SignerInformation signer2 = SignerInformation.addCounterSigners(signer1, counterSigners2);
        SignerInformationStore cs = signer2.getCounterSignatures();
        Collection csSigners = cs.getSigners();
        BcSignedDataTest.assertEquals((int)2, (int)csSigners.size());
        Iterator it = csSigners.iterator();
        while (it.hasNext()) {
            SignerInformation cSigner = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(cSigner.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertTrue((boolean)cSigner.isCounterSignature());
            BcSignedDataTest.assertNull((Object)cSigner.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_contentType));
            BcSignedDataTest.assertEquals((boolean)true, (boolean)cSigner.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    private void rsaPSSTest(String signatureAlgorithmName) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello world!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithmName).setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        siBuilder.setDirectSignature(true);
        gen.addSignerInfoGenerator(siBuilder.build(contentSigner, _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg, false);
        String digestName = signatureAlgorithmName.substring(0, signatureAlgorithmName.indexOf(119));
        MessageDigest md = MessageDigest.getInstance(digestName, BC);
        this.verifySignatures(s, md.digest("Hello world!".getBytes()));
    }

    private void subjectKeyIDTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(signatureCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        Store certStore = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(contentSigner, CMSTestUtil.createSubjectKeyId(signatureCert.getPublicKey()).getKeyIdentifier()));
        gen.addCertificates(certStore);
        gen.addCRLs(crlStore);
        CMSSignedData s = gen.generate(msg, true);
        BcSignedDataTest.assertEquals((int)3, (int)s.getVersion());
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certStore = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        Collection crls = crlStore.getMatches(null);
        BcSignedDataTest.assertEquals((int)1, (int)crls.size());
        BcSignedDataTest.assertTrue((boolean)crls.contains(new JcaX509CRLHolder(_signCrl)));
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate(msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certStore = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    private void encapsulatedTest(KeyPair signaturePair, X509Certificate signatureCert, String signatureAlgorithm) throws Exception {
        ConfigurableProvider provider = (ConfigurableProvider)((Object)Security.getProvider(BC));
        if (!provider.hasAlgorithm("Signature", signatureAlgorithm)) {
            return;
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(signatureCert);
        certList.add(_origCert);
        crlList.add(_signCrl);
        Store certs = new JcaCertStore(certList);
        JcaCRLStore crlStore = new JcaCRLStore(crlList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(BC).build(signaturePair.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(contentSigner, signatureCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(msg, true);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        Collection crls = crlStore.getMatches(null);
        BcSignedDataTest.assertEquals((int)1, (int)crls.size());
        BcSignedDataTest.assertTrue((boolean)crls.contains(new JcaX509CRLHolder(_signCrl)));
        gen = new CMSSignedDataGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates(s.getCertificates());
        s = gen.generate(msg, true);
        bIn = new ByteArrayInputStream(s.getEncoded());
        aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        certs = s.getCertificates();
        signers = s.getSignerInfos();
        c = signers.getSigners();
        it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.checkSignerStoreReplacement(s, signers);
    }

    private void checkSignerStoreReplacement(CMSSignedData orig, SignerInformationStore signers) throws Exception {
        CMSSignedData s = CMSSignedData.replaceSigners(orig, signers);
        Store certs = s.getCertificates();
        signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testUnsortedAttributes() throws Exception {
        CMSSignedData s = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(this.disorderedMessage), this.disorderedSet);
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    public void testNullContentWithSigner() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData s = gen.generate(new CMSAbsentContent(), false);
        ByteArrayInputStream bIn = new ByteArrayInputStream(s.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        s = new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        this.verifySignatures(s);
    }

    public void testWithAttributeCertificate() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(builder.build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        X509AttributeCertificateHolder attrCert = new X509AttributeCertificateHolder(CMSTestUtil.getAttributeCertificate().getEncoded());
        ArrayList<X509AttributeCertificateHolder> attrList = new ArrayList<X509AttributeCertificateHolder>();
        attrList.add(new X509AttributeCertificateHolder(attrCert.getEncoded()));
        Store store = new CollectionStore(attrList);
        gen.addAttributeCertificates(store);
        CMSSignedData sd = gen.generate(msg);
        BcSignedDataTest.assertEquals((int)4, (int)sd.getVersion());
        store = sd.getAttributeCertificates();
        Collection coll = store.getMatches(null);
        BcSignedDataTest.assertEquals((int)1, (int)coll.size());
        BcSignedDataTest.assertTrue((boolean)coll.contains(new X509AttributeCertificateHolder(attrCert.getEncoded())));
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs(sd, certs, null, null);
        this.verifySignatures(sd);
    }

    public void testCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData sd = gen.generate(msg);
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs(sd, certs, null, null);
        this.verifySignatures(sd);
    }

    public void testEncapsulatedCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData sd = gen.generate(msg, true);
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        sd = CMSSignedData.replaceCertificatesAndCRLs(sd, certs, null, null);
        this.verifySignatures(sd);
    }

    public void testCertOrdering1() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        certList.add(_signDsaCert);
        Store certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData sd = gen.generate(msg, true);
        certs = sd.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
    }

    public void testCertOrdering2() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_signCert);
        certList.add(_signDsaCert);
        certList.add(_origCert);
        Store certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData sd = gen.generate(msg, true);
        certs = sd.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
        BcSignedDataTest.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
    }

    public void testSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("Hello World!".getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData original = gen.generate(msg, true);
        gen = new CMSSignedDataGenerator();
        ContentSigner sha224Signer = new JcaContentSignerBuilder("SHA224withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha224Signer, _origCert));
        gen.addCertificates(certs);
        CMSSignedData newSD = gen.generate(msg, true);
        CMSSignedData sd = CMSSignedData.replaceSigners(original, newSD.getSignerInfos());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        BcSignedDataTest.assertEquals((String)CMSAlgorithm.SHA224.getId(), (String)signer.getDigestAlgOID());
        CMSSignedDataParser sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), sd.getEncoded());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedSamples() throws Exception {
        this.testSample("PSSSignDataSHA1Enc.sig");
        this.testSample("PSSSignDataSHA256Enc.sig");
        this.testSample("PSSSignDataSHA512Enc.sig");
    }

    public void testSamples() throws Exception {
        this.testSample("PSSSignData.data", "PSSSignDataSHA1.sig");
        this.testSample("PSSSignData.data", "PSSSignDataSHA256.sig");
        this.testSample("PSSSignData.data", "PSSSignDataSHA512.sig");
    }

    public void testCounterSig() throws Exception {
        CMSSignedData sig = new CMSSignedData(this.getInput("counterSig.p7m"));
        SignerInformationStore ss = sig.getSignerInfos();
        Collection signers = ss.getSigners();
        SignerInformationStore cs = ((SignerInformation)signers.iterator().next()).getCounterSignatures();
        Collection csSigners = cs.getSigners();
        BcSignedDataTest.assertEquals((int)1, (int)csSigners.size());
        Iterator it = csSigners.iterator();
        while (it.hasNext()) {
            SignerInformation cSigner = (SignerInformation)it.next();
            Collection certCollection = sig.getCertificates().getMatches(cSigner.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertTrue((boolean)cSigner.isCounterSignature());
            BcSignedDataTest.assertNull((Object)cSigner.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_contentType));
            BcSignedDataTest.assertEquals((boolean)true, (boolean)cSigner.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
        this.verifySignatures(sig);
    }

    private void testSample(String sigName) throws Exception {
        CMSSignedData sig = new CMSSignedData(this.getInput(sigName));
        this.verifySignatures(sig);
    }

    private void testSample(String messageName, String sigName) throws Exception {
        CMSSignedData sig = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(this.getInput(messageName)), this.getInput(sigName));
        this.verifySignatures(sig);
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    public void testForMultipleCounterSignatures() throws Exception {
        CMSSignedData sd = new CMSSignedData(xtraCounterSig);
        Iterator sI = sd.getSignerInfos().getSigners().iterator();
        while (sI.hasNext()) {
            SignerInformation sigI = (SignerInformation)sI.next();
            SignerInformationStore counter = sigI.getCounterSignatures();
            ArrayList sigs = new ArrayList(counter.getSigners());
            BcSignedDataTest.assertEquals((int)2, (int)sigs.size());
        }
    }

    private void verifySignatures(CMSSignedDataParser sp) throws Exception {
        Store certs = sp.getCertificates();
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            BcSignedDataTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
        }
    }

    static {
        _initialised = false;
        xtraCounterSig = Base64.decode("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");
    }

    private class TestCMSSignatureAlgorithmNameGenerator
    extends DefaultCMSSignatureAlgorithmNameGenerator {
        private TestCMSSignatureAlgorithmNameGenerator() {
        }

        void setDigestAlgorithmMapping(ASN1ObjectIdentifier oid, String algName) {
            super.setSigningDigestAlgorithmMapping(oid, algName);
        }

        void setEncryptionAlgorithmMapping(ASN1ObjectIdentifier oid, String algName) {
            super.setSigningEncryptionAlgorithmMapping(oid, algName);
        }
    }
}

