/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.path.validations;

import shaded.cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.KeyUsage;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.path.CertPathValidation;
import shaded.cfca.sadk.org.bouncycastle.cert.path.CertPathValidationContext;
import shaded.cfca.sadk.org.bouncycastle.cert.path.CertPathValidationException;
import shaded.cfca.sadk.org.bouncycastle.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean isMandatory;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.keyUsage);
        if (!context.isEndEntity()) {
            KeyUsage usage = KeyUsage.fromExtensions(certificate.getExtensions());
            if (usage != null) {
                if (!usage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.isMandatory) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    public Memoable copy() {
        return new KeyUsageValidation(this.isMandatory);
    }

    public void reset(Memoable other) {
        KeyUsageValidation v = (KeyUsageValidation)other;
        this.isMandatory = v.isMandatory;
    }
}

