/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.cmp.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.CertConfirmContent;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.CertRepMessage;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.PKIBody;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.PKIMessage;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CertReqMessages;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.CertReqMsg;
import shaded.cfca.sadk.org.bouncycastle.asn1.crmf.SubsequentMessage;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import shaded.cfca.sadk.org.bouncycastle.cert.CertException;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.CertificateStatus;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.GeneralPKIMessage;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import shaded.cfca.sadk.org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.CertificateRequestMessage;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.CertificateRequestMessageBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.PKMACBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import shaded.cfca.sadk.org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import shaded.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentSigner;
import shaded.cfca.sadk.org.bouncycastle.operator.ContentVerifierProvider;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.util.io.Streams;

public class AllTests
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    private static final String BC = "BC";
    private static final String TEST_DATA_HOME = "bc.test.data.home";

    public AllTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)AllTests.class);
    }

    public static Test suite() {
        return new TestSuite(AllTests.class);
    }

    public void setUp() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public void tearDown() {
    }

    public void testProtectedMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        ContentSigner signer = new JcaContentSignerBuilder("MD5WithRSAEncryption").setProvider(BC).build(kp.getPrivate());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, CertRepMessage.getInstance(new DERSequence(new DERSequence())))).addCMPCertificate(cert).build(signer);
        X509Certificate jcaCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(message.getCertificates()[0]);
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(BC).build(jcaCert.getPublicKey());
        AllTests.assertTrue((boolean)message.verify(verifierProvider));
        AllTests.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        AllTests.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
    }

    public void testMacProtectedMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(1, CertRepMessage.getInstance(new DERSequence(new DERSequence())))).addCMPCertificate(cert).build(new PKMACBuilder(new JcePKMACValuesCalculator().setProvider(BC)).build("secret".toCharArray()));
        PKMACBuilder pkMacBuilder = new PKMACBuilder(new JcePKMACValuesCalculator().setProvider(BC));
        AllTests.assertTrue((boolean)message.verify(pkMacBuilder, "secret".toCharArray()));
        AllTests.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        AllTests.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
    }

    public void testConfirmationMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        GeneralName sender = new GeneralName(new X500Name("CN=Sender"));
        GeneralName recipient = new GeneralName(new X500Name("CN=Recip"));
        CertificateConfirmationContent content = new CertificateConfirmationContentBuilder().addAcceptedCertificate(cert, BigInteger.valueOf(1L)).build(new JcaDigestCalculatorProviderBuilder().build());
        ContentSigner signer = new JcaContentSignerBuilder("MD5WithRSAEncryption").setProvider(BC).build(kp.getPrivate());
        ProtectedPKIMessage message = new ProtectedPKIMessageBuilder(sender, recipient).setBody(new PKIBody(24, content.toASN1Structure())).addCMPCertificate(cert).build(signer);
        X509Certificate jcaCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(message.getCertificates()[0]);
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider(BC).build(jcaCert.getPublicKey());
        AllTests.assertTrue((boolean)message.verify(verifierProvider));
        AllTests.assertEquals((Object)sender, (Object)message.getHeader().getSender());
        AllTests.assertEquals((Object)recipient, (Object)message.getHeader().getRecipient());
        content = new CertificateConfirmationContent(CertConfirmContent.getInstance(message.getBody().getContent()));
        CertificateStatus[] statusList = content.getStatusMessages();
        AllTests.assertEquals((int)1, (int)statusList.length);
        AllTests.assertTrue((boolean)statusList[0].isVerified(cert, new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()));
    }

    public void testSampleCr() throws Exception {
        PKIMessage msg = AllTests.loadMessage("sample_cr.der");
        ProtectedPKIMessage procMsg = new ProtectedPKIMessage(new GeneralPKIMessage(msg));
        AllTests.assertTrue((boolean)procMsg.verify(new PKMACBuilder(new JcePKMACValuesCalculator().setProvider(BC)), "TopSecret1234".toCharArray()));
    }

    public void testSubsequentMessage() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        X509CertificateHolder cert = AllTests.makeV3Certificate(kp, "CN=Test", kp, "CN=Test");
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(BC).build(kp.getPrivate());
        GeneralName user = new GeneralName(new X500Name("CN=Test"));
        CertificateRequestMessageBuilder builder = new JcaCertificateRequestMessageBuilder(BigInteger.valueOf(1L)).setPublicKey(kp.getPublic()).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        ProtectedPKIMessage certRequestMsg = new ProtectedPKIMessageBuilder(user, user).setTransactionID(new byte[]{1, 2, 3, 4, 5}).setBody(new PKIBody(7, new CertReqMessages(builder.build().toASN1Structure()))).addCMPCertificate(cert).build(signer);
        ProtectedPKIMessage msg = new ProtectedPKIMessage(new GeneralPKIMessage(certRequestMsg.toASN1Structure().getEncoded()));
        CertReqMessages reqMsgs = CertReqMessages.getInstance(msg.getBody().getContent());
        CertReqMsg reqMsg = reqMsgs.toCertReqMsgArray()[0];
        AllTests.assertEquals((int)2, (int)reqMsg.getPopo().getType());
    }

    public void testNotBeforeNotAfter() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(512);
        KeyPair kp = kGen.generateKeyPair();
        this.doNotBeforeNotAfterTest(kp, new Date(0L), new Date(60000L));
        this.doNotBeforeNotAfterTest(kp, null, new Date(60000L));
        this.doNotBeforeNotAfterTest(kp, new Date(0L), null);
    }

    private void doNotBeforeNotAfterTest(KeyPair kp, Date notBefore, Date notAfter) throws Exception {
        CertificateRequestMessageBuilder builder = new JcaCertificateRequestMessageBuilder(BigInteger.valueOf(1L)).setPublicKey(kp.getPublic()).setProofOfPossessionSubsequentMessage(SubsequentMessage.encrCert);
        builder.setValidity(notBefore, notAfter);
        CertificateRequestMessage message = builder.build();
        if (notBefore != null) {
            AllTests.assertEquals((long)notBefore.getTime(), (long)message.getCertTemplate().getValidity().getNotBefore().getDate().getTime());
        } else {
            AllTests.assertNull((Object)message.getCertTemplate().getValidity().getNotBefore());
        }
        if (notAfter != null) {
            AllTests.assertEquals((long)notAfter.getTime(), (long)message.getCertTemplate().getValidity().getNotAfter().getDate().getTime());
        } else {
            AllTests.assertNull((Object)message.getCertTemplate().getValidity().getNotAfter());
        }
    }

    private static X509CertificateHolder makeV3Certificate(KeyPair subKP, String _subDN, KeyPair issKP, String _issDN) throws GeneralSecurityException, IOException, OperatorCreationException, CertException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder v1CertGen = new JcaX509v3CertificateBuilder(new X500Name(_issDN), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(_subDN), subPub);
        ContentSigner signer = new JcaContentSignerBuilder("SHA1WithRSA").setProvider(BC).build(issPriv);
        X509CertificateHolder certHolder = v1CertGen.build(signer);
        ContentVerifierProvider verifier = new JcaContentVerifierProviderBuilder().setProvider(BC).build(issPub);
        AllTests.assertTrue((boolean)certHolder.isSignatureValid(verifier));
        return certHolder;
    }

    private static PKIMessage loadMessage(String name) {
        String dataHome = System.getProperty(TEST_DATA_HOME);
        if (dataHome == null) {
            throw new IllegalStateException("bc.test.data.home property not set");
        }
        try {
            return PKIMessage.getInstance(ASN1Primitive.fromByteArray(Streams.readAll(new FileInputStream(dataHome + "/cmp/" + name))));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

