/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X962NamedCurves;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ECPoint;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9IntegerConverter;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Base64;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode("MDcwEwYHKoZIzj0CAQYIKoZIzj0DAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] expPub = Base64.decode("MIH8MIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEDIAADG5xRI+Iki/JrvL20hoDUa7Cggzorv5B9yyqSMjYu");
    private byte[] namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
    private byte[] expPriv = Base64.decode("MIHnAgEAMIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEECDAGAgEBBAEU");

    private void encodePublicKey() throws Exception {
        ASN1Primitive o;
        ECPoint point;
        DEROctetString p;
        X962Parameters params;
        SubjectPublicKeyInfo info;
        X9IntegerConverter conv = new X9IntegerConverter();
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        if (conv.getByteLength(ecP.getCurve()) != 30) {
            this.fail("wrong byte length reported for curve");
        }
        if (ecP.getCurve().getFieldSize() != 239) {
            this.fail("wrong field size reported for curve");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(X9ObjectIdentifiers.prime192v1)), (p = new DEROctetString((point = ecP.getG().multiply(BigInteger.valueOf(100L))).getEncoded(true))).getOctets())).getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        X9ECPoint x9P = new X9ECPoint(ecP.getCurve(), p);
        if (!Arrays.areEqual(p.getOctets(), x9P.getPoint().getEncoded())) {
            this.fail("point encoding not preserved");
        }
        if (!info.equals(o = ASN1Primitive.fromByteArray(this.namedPub))) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(ecP)), p.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!info.equals(o = ASN1Primitive.fromByteArray(this.expPub))) {
            this.fail("failed public explicit equality");
        }
    }

    private void encodePrivateKey() throws Exception {
        ASN1Primitive o;
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters params = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKey(BigInteger.valueOf(10L)));
        if (!this.areEqual(info.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!info.equals(o = ASN1Primitive.fromByteArray(this.namedPriv))) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(ecP)), new ECPrivateKey(BigInteger.valueOf(20L)))).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!info.equals(o = ASN1Primitive.fromByteArray(this.expPriv))) {
            this.fail("failed private explicit equality");
        }
    }

    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] args) {
        X9Test.runTest(new X9Test());
    }
}

