/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import shaded.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPRequest;
import shaded.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponse;
import shaded.cfca.sadk.org.bouncycastle.asn1.ocsp.ResponseBytes;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Base64;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTestResult;
import shaded.cfca.sadk.org.bouncycastle.util.test.Test;
import shaded.cfca.sadk.org.bouncycastle.util.test.TestResult;

public class OCSPTest
implements Test {
    private byte[] unsignedReq = Base64.decode("MEIwQDA+MDwwOjAJBgUrDgMCGgUABBRDb9GODnq7lRhSkEqw4XX24huERwQUkY4ja6eKuDlkVP9hRgkEvIWqHPECAQE=");
    private byte[] signedReq = Base64.decode("MIIC9jBAMD4wPDA6MAkGBSsOAwIaBQAEFENv0Y4OeruVGFKQSrDhdfbiG4RHBBTcMr1fP+mZAxbF2ZdehWxn6mtAngIBAaCCArAwggKsMA0GCSqGSIb3DQEBBQUAA4GBAAzHBm4nL5AcRQB3Jkz7ScNeZF+GbRZ0p4kBDTnqi3IeESuso12yJhpqqyijdnj5gd4/GsSAgdluLHyYZ6wgozV7G9MDXCnFnG4PBUW05HaVX81JYAp+amVyU0NOgNrG90npVBsHb0o+UlkxNgMiEbSkp/TeGb6YURsYKhmwp7BgoIICFTCCAhEwggINMIIBdqADAgECAgEBMA0GCSqGSIb3DQEBBAUAMCUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxCzAJBgNVBAYTAkFVMB4XDTA0MTAyNDEzNDc0M1oXDTA1MDIwMTEzNDc0M1owJTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTELMAkGA1UEBhMCQVUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAJBmLeIzthMHUeTkOeJ76iBxcMHY31o/i3a9VT12y2FcS/ejJmeUCMTdtwl5alOwXY66vF4DyT1VU/nJG3mHpSoqq7qrMXOIFGcXg1WfoJRrQgTOLdQ6bod7i9ME/EjEJy70orh0nVS7NGcu0R5TjcbLde2J5zxjb/W9wqfyRovJAgMBAAGjTTBLMB0GA1UdDgQWBBTcMr1fP+mZAxbF2ZdehWxn6mtAnjAfBgNVHSMEGDAWgBTcMr1fP+mZAxbF2ZdehWxn6mtAnjAJBgNVHRMEAjAAMA0GCSqGSIb3DQEBBAUAA4GBAF/4EH1KkNrNxocJPIp7lThmG1KIVYESIadowMowrbok46ESofRFOIPku07W+e1Y1Y1KXLIiPMG3IGwrBrn04iLsbbBUiN37BcC/VyT4xKJ2MYscGjKLua/9bU0lOyeTRAwqb8towWRd5lLYAI3RQ7dhStUTFp3Vqd803PJ/cpR6");
    private byte[] response = Base64.decode("MIIFnAoBAKCCBZUwggWRBgkrBgEFBQcwAQEEggWCMIIFfjCCARehgZ8wgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4YDzIwMDMwNDAyMTIzNDU4WjBiMGAwOjAJBgUrDgMCGgUABBRs07IuoCWNmcEl1oHwIak1BPnX8QQUtGyl/iL9WJ1VxjxFj0hAwJ/s1AcCAQKhERgPMjAwMjA4MjkwNzA5MjZaGA8yMDAzMDQwMjEyMzQ1OFowDQYJKoZIhvcNAQEFBQADgYEAfbN0TCRFKdhsmvOdUoiJ+qvygGBzDxD/VWhXYA+16AphHLIWNABR3CgHB3zWtdy2j7DJmQ/R7qKj7dUhWLSqclAiPgFtQQ1YvSJAYfEIdyHkxv4NP0LSogxrumANcDyC9yt/W9yHjD2ICPBIqCsZLuLkOHYi5DlwWe9Zm9VFwCGgggPMMIIDyDCCA8QwggKsoAMCAQICAQYwDQYJKoZIhvcNAQEFBQAwgZQxFDASBgNVBAMTC1RDUy1DQSBPQ1NQMSYwJAYJKoZIhvcNAQkBFhd0Y3MtY2FAdGNzLWNhLnRjcy5jby5pbjEMMAoGA1UEChMDVENTMQwwCgYDVQQLEwNBVEMxEjAQBgNVBAcTCUh5ZGVyYWJhZDEXMBUGA1UECBMOQW5kaHJhIHByYWRlc2gxCzAJBgNVBAYTAklOMB4XDTAyMDgyOTA3MTE0M1oXDTAzMDgyOTA3MTE0M1owgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM+XWW4caMRv46D7L6Bv8iwtKgmQu0SAybmFRJiz12qXzdvTLt8C75OdgmUomxp0+gW/4XlTPUqOMQWv463aZRv9Ust4f8MHEJh4ekP/NS9+d8vEO3P40ntQkmSMcFmtA9E1koUtQ3MSJlcs441JjbgUaVnmjDmmniQnZY4bU3tVAgMBAAGjgZowgZcwDAYDVR0TAQH/BAIwADALBgNVHQ8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwkwNgYIKwYBBQUHAQEEKjAoMCYGCCsGAQUFBzABhhpodHRwOi8vMTcyLjE5LjQwLjExMDo3NzAwLzAtBgNVHR8EJjAkMCKgIKAehhxodHRwOi8vMTcyLjE5LjQwLjExMC9jcmwuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQB6FovM3B4VDDZ15o12gnADZsIk9fTAczLlcrmXLNN4PgmqgnwF0Ymj3bD5SavDOXxbA65AZJ7rBNAguLUo+xVkgxmoBH7R2sBxjTCcr07NEadxM3HQkt0aX5XYEl8eRoifwqYAI9h0ziZfTNes8elNfb3DoPPjqq6VmMg0f0iMS4W8LjNPorjRB+kIosa1deAGPhq0eJ8yr0/s2QR2/WFD5P4aXc8IKWleklnIImS3zqiPrq6tl2Bm8DZj7vXlTOwmraSQxUwzCKwYob1yGvNOUQTqpG6jxn7jgDawHU1+WjWQe4Q34/pWeGLysxTraMa+Ug9kPe+jy/qRX2xwvKBZ");

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult unsignedRequest() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.unsignedReq));
            OCSPRequest req = OCSPRequest.getInstance(aIn.readObject());
            if (!this.isSameAs(req.getEncoded(), this.unsignedReq)) {
                return new SimpleTestResult(false, this.getName() + ": OCSP unsigned request failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed unsigned exception - " + e.toString(), e);
        }
    }

    private TestResult signedRequest() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.signedReq));
            OCSPRequest req = OCSPRequest.getInstance(aIn.readObject());
            if (!this.isSameAs(req.getEncoded(), this.signedReq)) {
                return new SimpleTestResult(false, this.getName() + ": OCSP signed request failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed signed exception - " + e.toString(), e);
        }
    }

    private TestResult response() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.response));
            OCSPResponse resp = OCSPResponse.getInstance(aIn.readObject());
            ResponseBytes rBytes = ResponseBytes.getInstance(resp.getResponseBytes());
            aIn = new ASN1InputStream(new ByteArrayInputStream(rBytes.getResponse().getOctets()));
            BasicOCSPResponse bResp = BasicOCSPResponse.getInstance(aIn.readObject());
            resp = new OCSPResponse(resp.getResponseStatus(), new ResponseBytes(rBytes.getResponseType(), new DEROctetString(bResp.getEncoded())));
            if (!this.isSameAs(resp.getEncoded(), this.response)) {
                return new SimpleTestResult(false, this.getName() + ": OCSP response failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed response exception - " + e.toString(), e);
        }
    }

    public TestResult perform() {
        TestResult res = this.unsignedRequest();
        if (!res.isSuccessful()) {
            return res;
        }
        res = this.signedRequest();
        if (!res.isSuccessful()) {
            return res;
        }
        return this.response();
    }

    public String getName() {
        return "OCSP";
    }

    public static void main(String[] args) {
        OCSPTest test = new OCSPTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

