/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.cmp;

import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.PKIBody;
import shaded.cfca.sadk.org.bouncycastle.asn1.cmp.PKIHeader;

public class ProtectedPart
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;

    private ProtectedPart(ASN1Sequence seq) {
        this.header = PKIHeader.getInstance(seq.getObjectAt(0));
        this.body = PKIBody.getInstance(seq.getObjectAt(1));
    }

    public static ProtectedPart getInstance(Object o) {
        if (o instanceof ProtectedPart) {
            return (ProtectedPart)o;
        }
        if (o != null) {
            return new ProtectedPart(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ProtectedPart(PKIHeader header, PKIBody body) {
        this.header = header;
        this.body = body;
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.header);
        v.add(this.body);
        return new DERSequence(v);
    }
}

