/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.jcajce.asymmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import shaded.cfca.sadk.algorithm.sm2.SM2Crypto;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.util.Base64;

public class SM2Cipher
extends CipherSpi {
    protected int mode;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected boolean forEncryption;

    protected byte[] engineDoFinal(byte[] input, int offset, int len) throws IllegalBlockSizeException, BadPaddingException {
        SM2Crypto crypto = new SM2Crypto();
        byte[] finalData = null;
        try {
            if (this.mode == 1) {
                SM2PublicKey pubKey = (SM2PublicKey)this.publicKey;
                crypto.initEncrypt(pubKey.getQ());
                finalData = crypto.encrypt(input);
            } else if (this.mode == 2) {
                SM2PrivateKey priKey = (SM2PrivateKey)this.privateKey;
                crypto.initDecrypt(priKey.getDByInt());
                finalData = crypto.decrypt(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalData;
    }

    protected int engineDoFinal(byte[] input, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    protected int engineGetBlockSize() {
        return 32;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int arg0) {
        return 0;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int mode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (mode == 1 && key instanceof SM2PublicKey) {
            this.publicKey = (SM2PublicKey)key;
            this.mode = mode;
            this.forEncryption = true;
        } else if (mode == 2 && key instanceof SM2PrivateKey) {
            this.privateKey = (SM2PrivateKey)key;
            this.mode = mode;
            this.forEncryption = false;
        } else {
            throw new InvalidParameterException("key type error,SM2PublicKey or SM2PrivateKey expected!");
        }
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameterSpec arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameters arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
    }

    protected void engineSetMode(String arg0) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
    }

    protected byte[] engineUpdate(byte[] arg0, int arg1, int arg2) {
        return null;
    }

    protected int engineUpdate(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException {
        return 0;
    }

    protected int engineGetKeySize(Key paramKey) throws InvalidKeyException {
        System.out.println("SM2 KEY SIZE:" + paramKey.getEncoded().length);
        return 32;
    }

    public static class SM2CipherinBase64
    extends SM2Cipher {
        protected byte[] engineDoFinal(byte[] input, int offset, int len) throws IllegalBlockSizeException, BadPaddingException {
            if (this.forEncryption) {
                return Base64.encode(super.engineDoFinal(input, offset, len));
            }
            byte[] tmpData = Base64.decode(input);
            return super.engineDoFinal(tmpData, offset, tmpData.length);
        }
    }
}

