/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.asn1.pkcs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import shaded.cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.algorithm.sm2.SM4Engine;
import shaded.cfca.sadk.asn1.parser.ASN1Parser;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.BERSequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import shaded.cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import shaded.cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.system.global.SM2ContextConfig;
import shaded.cfca.sadk.util.Base64;
import shaded.cfca.sadk.x509.certificate.X509Cert;

public class PKCS12_SM2
implements ASN1Encodable,
PKCSObjectIdentifiers {
    private ASN1Sequence privateInfo = null;
    private ASN1Sequence publicInfo = null;
    private ASN1OctetString pubOctString;
    private ASN1OctetString priOctString;
    private SM2PrivateKey SM2PrivateKey;
    private boolean isDecryped = false;

    public static PKCS12_SM2 getInstance(Object o) throws PKIException {
        if (o == null || o instanceof PKCS12_SM2) {
            return (PKCS12_SM2)o;
        }
        if (o instanceof ASN1Sequence) {
            return new PKCS12_SM2((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
    }

    public PKCS12_SM2() {
    }

    public PKCS12_SM2(ASN1Sequence publicInfo, ASN1Sequence privateInfo) {
        this.publicInfo = publicInfo;
        this.privateInfo = privateInfo;
    }

    public void load(byte[] data) throws IOException, PKIException {
        ASN1InputStream asn1InputStream = null;
        boolean isB64 = ASN1Parser.isBase64Compatability(data);
        if (isB64) {
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        asn1InputStream = new ASN1InputStream(bis);
        ASN1Sequence asn1Seq = (ASN1Sequence)asn1InputStream.readObject();
        this.parseSM2(asn1Seq);
        asn1InputStream.close();
    }

    public void parseSM2(ASN1Sequence seq) throws PKIException {
        int size = seq.size();
        if (size == 3) {
            ASN1Sequence pri = (ASN1Sequence)seq.getObjectAt(1);
            ASN1Sequence pub = (ASN1Sequence)seq.getObjectAt(2);
            if (pri.size() != 3) {
                throw new PKIException("the sm2 file is not right format,can not get the private part");
            }
            this.priOctString = (ASN1OctetString)pri.getObjectAt(2);
            if (pub.size() == 2) {
                this.pubOctString = (ASN1OctetString)pub.getObjectAt(1);
            } else {
                throw new PKIException("the sm2 file is not right format.can not get the public part");
            }
        }
    }

    public PKCS12_SM2(ASN1Sequence seq) throws PKIException {
        this.parseSM2(seq);
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public PrivateKey getPrivateKey() throws PKIException {
        if (!this.isDecryped) {
            throw new PKIException(PKIException.DECRYPT_P12_ERR, PKIException.DECRYPT_P12_ERR_DES);
        }
        return this.SM2PrivateKey;
    }

    public SM2PrivateKey getPrivateKey(String pass) throws Exception {
        this.decrypt(pass);
        return this.SM2PrivateKey;
    }

    public void decrypt(String pfxFilePassword) throws PKIException, UnsupportedEncodingException, DataLengthException, IllegalStateException, InvalidCipherTextException {
        if (pfxFilePassword != null) {
            byte[] src = pfxFilePassword.getBytes("UTF8");
            byte[] hash = PKCS12_SM2.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(false, params);
            byte[] encryptPriKey = this.priOctString.getOctets();
            boolean isB64 = ASN1Parser.isBase64Compatability(encryptPriKey);
            if (isB64) {
                encryptPriKey = Base64.decode(encryptPriKey);
            }
            int len = cipher.getOutputSize(encryptPriKey.length);
            byte[] priKey = new byte[len];
            int len1 = cipher.processBytes(encryptPriKey, 0, encryptPriKey.length, priKey, 0);
            int len2 = cipher.doFinal(priKey, len1);
            int total = len1 + len2;
            X509Cert cert = this.getPublicCert()[0];
            SM2PublicKey pubKey = (SM2PublicKey)cert.getPublicKey();
            byte[] pubX = pubKey.getPubXByBytes();
            byte[] pubY = pubKey.getPubYByBytes();
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(priKey, 0, removeZeroSourceData, 0, total);
                this.SM2PrivateKey = new SM2PrivateKey(removeZeroSourceData, pubX, pubY);
            } else {
                this.SM2PrivateKey = new SM2PrivateKey(priKey, pubX, pubY);
            }
        } else {
            throw new PKIException("the pass word should not be null");
        }
        this.isDecryped = true;
    }

    public X509Cert[] getPublicCert() throws PKIException {
        byte[] cert = this.pubOctString.getOctets();
        X509Cert[] certChain = new X509Cert[]{new X509Cert(cert)};
        return certChain;
    }

    public static void generateSM2File(X509Cert x509Cert, PrivateKey priKey, String passWord, String fileName) throws PKIException, IOException, DataLengthException, IllegalStateException, InvalidCipherTextException {
        PKCS12_SM2 p12_1 = PKCS12_SM2.generateSM2(x509Cert, priKey, passWord);
        FileOutputStream fos = null;
        ByteArrayOutputStream bos = null;
        ASN1OutputStream dos = null;
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            if (!SM2ContextConfig.getBase64State()) {
                fos = new FileOutputStream(f);
                dos = new DEROutputStream(fos);
                ((DEROutputStream)dos).writeObject(p12_1);
            } else {
                fos = new FileOutputStream(f);
                bos = new ByteArrayOutputStream();
                dos = new DEROutputStream(bos);
                ((DEROutputStream)dos).writeObject(p12_1);
                byte[] data = bos.toByteArray();
                Base64.encode(data, fos);
            }
        }
        catch (Exception e) {
            throw new PKIException("can not create sm2 file: " + e.getMessage());
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
    }

    public static byte[] generateSM2Data(X509Cert x509Cert, PrivateKey priKey, String passWord) throws IOException, PKIException, DataLengthException, IllegalStateException, InvalidCipherTextException {
        PKCS12_SM2 p12_SM2 = PKCS12_SM2.generateSM2(x509Cert, priKey, passWord);
        ByteArrayOutputStream bos = null;
        DEROutputStream dos = null;
        if (!SM2ContextConfig.getBase64State()) {
            bos = new ByteArrayOutputStream();
            dos = new DEROutputStream(bos);
            dos.writeObject(p12_SM2);
            return bos.toByteArray();
        }
        bos = new ByteArrayOutputStream();
        dos = new DEROutputStream(bos);
        dos.writeObject(p12_SM2);
        byte[] noB64ByteData = bos.toByteArray();
        byte[] b64ByteData = Base64.encode(noB64ByteData);
        return b64ByteData;
    }

    private static PKCS12_SM2 generateSM2(X509Cert x509Cert, PrivateKey priKey, String passWord) throws IOException, PKIException, DataLengthException, IllegalStateException, InvalidCipherTextException {
        if ("".equals(passWord)) {
            throw new PKIException("the pass word should not be null");
        }
        byte[] src = passWord.getBytes("UTF8");
        byte[] hash = PKCS12_SM2.KDF(src);
        byte[] iv = new byte[16];
        System.arraycopy(hash, 0, iv, 0, 16);
        byte[] key = new byte[16];
        System.arraycopy(hash, 16, key, 0, 16);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
        cipher.init(true, params);
        SM2PrivateKey sm2PrvKey = null;
        if (!(priKey instanceof SM2PrivateKey)) {
            throw new PKIException("priKey is not SM2PrivateKey, SM2PrivateKey expected!");
        }
        sm2PrvKey = (SM2PrivateKey)priKey;
        byte[] prvData = sm2PrvKey.getDByBytes();
        byte[] encryptPrvData = null;
        int len = cipher.getOutputSize(prvData.length);
        byte[] tempData = new byte[len];
        int len1 = cipher.processBytes(prvData, 0, prvData.length, tempData, 0);
        int len2 = cipher.doFinal(tempData, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] removeZeroSourceData = new byte[total];
            System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
            encryptPrvData = removeZeroSourceData;
        } else {
            encryptPrvData = tempData;
        }
        ASN1EncodableVector publicInfoVector = new ASN1EncodableVector();
        publicInfoVector.add(PKCSObjectIdentifiers.sm2Data);
        Certificate cert = x509Cert.getCertStructure();
        DEROctetString pubDEROctetString = new DEROctetString(cert.getEncoded());
        publicInfoVector.add(pubDEROctetString);
        DERSequence publicInfo = new DERSequence(publicInfoVector);
        ASN1EncodableVector privateInfoVector = new ASN1EncodableVector();
        privateInfoVector.add(PKCSObjectIdentifiers.sm2Data);
        privateInfoVector.add(PKCSObjectIdentifiers.SM4_CBC);
        DEROctetString prvDEROctetString = new DEROctetString(encryptPrvData);
        privateInfoVector.add(prvDEROctetString);
        DERSequence privateInfo = new DERSequence(privateInfoVector);
        return new PKCS12_SM2(publicInfo, privateInfo);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1L));
        v.add(this.privateInfo);
        v.add(this.publicInfo);
        return new BERSequence(v);
    }
}

