/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.util;

import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import shaded.cfca.sadk.algorithm.common.CBCParam;
import shaded.cfca.sadk.algorithm.common.Mechanism;
import shaded.cfca.sadk.algorithm.util.PKCS8ToPKCS1Util;
import shaded.cfca.sadk.lib.crypto.jni.JNIRSA;
import shaded.cfca.sadk.lib.crypto.jni.JNISymAlg;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.RSAEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.util.PrivateKeyFactory;
import shaded.cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;

public class RSAAndItsCloseSymAlgUtil {
    private static int HEADER_LENGTH = 10;
    private static int DES3_BLOCK_SIZE = 8;

    public static byte[] crypto(boolean useJNI, boolean forEncryption, byte[] key, byte[] sourceData, Mechanism algName) throws Exception {
        if (algName.getMechanismType().indexOf("RC4") != -1) {
            return RSAAndItsCloseSymAlgUtil.useRC4Encrypt(useJNI, forEncryption, key, sourceData);
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            return RSAAndItsCloseSymAlgUtil.useDesedeCBCEncrypt(useJNI, forEncryption, key, sourceData, param.getIv());
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            return RSAAndItsCloseSymAlgUtil.useDesedeECBEncrypt(useJNI, forEncryption, key, sourceData);
        }
        if (algName.getMechanismType().indexOf("RSA") != -1) {
            return RSAAndItsCloseSymAlgUtil.useRSAECBEncrypt(forEncryption, key, sourceData);
        }
        throw new Exception("can not support this algorithm to crypto:" + algName.getMechanismType());
    }

    public static byte[] rsaEncrypt(boolean isEncrypted, Key rsaKey, byte[] input) throws Exception {
        return RSAAndItsCloseSymAlgUtil.useRSAECBEncrypt(isEncrypted, rsaKey.getEncoded(), input);
    }

    public static byte[] rsaEncryptByJNI(boolean isEncrypted, Key rsaKey, byte[] input) throws Exception {
        if (isEncrypted) {
            return RSAAndItsCloseSymAlgUtil.encryptByJNI(input, rsaKey);
        }
        return RSAAndItsCloseSymAlgUtil.decryptByJNI(input, rsaKey);
    }

    private static byte[] addPKCS1Padding(byte[] srcData, RSAPublicKey pubKey) {
        int bitLen = pubKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] block = new byte[blockLen];
        SecureRandom random = new SecureRandom();
        random.nextBytes(block);
        block[0] = 0;
        block[1] = 2;
        int inLen = srcData.length;
        for (int i = 2; i != block.length - inLen - 1; ++i) {
            while (block[i] == 0) {
                block[i] = (byte)random.nextInt();
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(srcData, 0, block, block.length - inLen, inLen);
        return block;
    }

    private static byte[] delPKCS1Padding(byte[] paddingData) throws Exception {
        byte pad;
        int start;
        byte type = paddingData[1];
        if (type != 1 && type != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        for (start = 2; start != paddingData.length && (pad = paddingData[start]) != 0; ++start) {
            if (type != 1 || pad == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++start > paddingData.length || start < HEADER_LENGTH) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[paddingData.length - start];
        System.arraycopy(paddingData, start, result, 0, result.length);
        return result;
    }

    private static byte[] encryptByJNI(byte[] srcData, Key publicKey) throws Exception {
        if (srcData == null) {
            throw new Exception("the source data is null,can not encrypt!!!");
        }
        RSAPublicKey pubKey = (RSAPublicKey)publicKey;
        byte[] pkcs1PubKey = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(pubKey);
        byte[] input = RSAAndItsCloseSymAlgUtil.addPKCS1Padding(srcData, pubKey);
        int bitLen = pubKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] output = new byte[blockLen];
        JNIRSA.dowithPublicKey(input, pkcs1PubKey, output);
        return output;
    }

    private static byte[] decryptByJNI(byte[] encryptedData, Key privateKey) throws Exception {
        if (encryptedData == null) {
            throw new Exception("the encrypt data is null,can not decrypt!!!");
        }
        RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
        byte[] pkcs1PriKey = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(priKey);
        int bitLen = priKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] output = new byte[blockLen];
        JNIRSA.dowithPrivateKey(encryptedData, pkcs1PriKey, output);
        return RSAAndItsCloseSymAlgUtil.delPKCS1Padding(output);
    }

    private static byte[] useRC4Encrypt(boolean useJNI, boolean isEncrypted, byte[] key, byte[] input) throws Exception {
        byte[] out = new byte[input.length];
        if (useJNI) {
            JNISymAlg jni = new JNISymAlg();
            if (isEncrypted) {
                jni.encryptInit(JNISymAlg.NID_rc4, key, null);
                byte[] cipher = new byte[input.length];
                int len1 = jni.encryptProcess(input, 0, input.length, cipher, 0);
                jni.encryptFinal(cipher, len1);
                return cipher;
            }
            jni.decryptInit(JNISymAlg.NID_rc4, key, null);
            byte[] plainText = new byte[input.length];
            int len1 = jni.decryptProcess(input, 0, input.length, plainText, 0);
            jni.decryptFinal(plainText, len1);
            return plainText;
        }
        RC4Engine rc4 = new RC4Engine();
        KeyParameter param = new KeyParameter(key);
        rc4.init(isEncrypted, param);
        rc4.processBytes(input, 0, input.length, out, 0);
        return out;
    }

    private static byte[] useDesedeECBEncrypt(boolean useJNI, boolean isEncrypted, byte[] key, byte[] input) throws Exception {
        if (useJNI) {
            JNISymAlg jni = new JNISymAlg();
            if (isEncrypted) {
                jni.encryptInit(JNISymAlg.NID_des_ede3_ecb, key, null);
                byte[] cipher = new byte[input.length + (DES3_BLOCK_SIZE - input.length % DES3_BLOCK_SIZE)];
                int len1 = jni.encryptProcess(input, 0, input.length, cipher, 0);
                jni.encryptFinal(cipher, len1);
                return cipher;
            }
            jni.decryptInit(JNISymAlg.NID_des_ede3_ecb, key, null);
            byte[] plainText = new byte[input.length];
            int len1 = jni.decryptProcess(input, 0, input.length, plainText, 0);
            int len2 = jni.decryptFinal(plainText, len1);
            int total = len1 + len2;
            byte[] out2 = new byte[total];
            System.arraycopy(plainText, 0, out2, 0, total);
            return out2;
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new DESedeEngine(), new PKCS7Padding());
        KeyParameter params = new KeyParameter(key);
        cipher.init(isEncrypted, params);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useDesedeCBCEncrypt(boolean useJNI, boolean isEncrypted, byte[] key, byte[] input, byte[] iv) throws Exception {
        if (useJNI) {
            JNISymAlg jni = new JNISymAlg();
            if (isEncrypted) {
                jni.encryptInit(JNISymAlg.NID_des_ede3_cbc, key, iv);
                byte[] cipher = new byte[input.length + (DES3_BLOCK_SIZE - input.length % DES3_BLOCK_SIZE)];
                int len1 = jni.encryptProcess(input, 0, input.length, cipher, 0);
                jni.encryptFinal(cipher, len1);
                return cipher;
            }
            jni.decryptInit(JNISymAlg.NID_des_ede3_cbc, key, iv);
            byte[] plainText = new byte[input.length];
            int len1 = jni.decryptProcess(input, 0, input.length, plainText, 0);
            int len2 = jni.decryptFinal(plainText, len1);
            int total = len1 + len2;
            byte[] out2 = new byte[total];
            System.arraycopy(plainText, 0, out2, 0, total);
            return out2;
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()), new PKCS7Padding());
        ParametersWithIV param = new ParametersWithIV(new KeyParameter(key), iv);
        cipher.init(isEncrypted, param);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useRSAECBEncrypt(boolean isEncrypted, byte[] key, byte[] input) throws Exception {
        RSAKeyParameters param = null;
        if (isEncrypted) {
            SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance(key);
            param = (RSAKeyParameters)PublicKeyFactory.createKey(pubKeyInfo);
            AsymmetricBlockCipher eng = new RSAEngine();
            eng = new PKCS1Encoding(eng);
            eng.init(true, param);
            return eng.processBlock(input, 0, input.length);
        }
        param = (RSAKeyParameters)PrivateKeyFactory.createKey(key);
        AsymmetricBlockCipher eng = new RSAEngine();
        eng = new PKCS1Encoding(eng);
        eng.init(false, param);
        return eng.processBlock(input, 0, input.length);
    }

    public static byte[] generateSecretKey(String symmetricAlgorithm) throws Exception {
        String contentEncryptionAlg = symmetricAlgorithm.toUpperCase();
        SecureRandom random = new SecureRandom();
        if (contentEncryptionAlg.indexOf("RC4") != -1) {
            byte[] keyBytes = new byte[16];
            random.nextBytes(keyBytes);
            return keyBytes;
        }
        if (contentEncryptionAlg.indexOf("DESEDE") != -1) {
            DESedeKeyGenerator keyGen = new DESedeKeyGenerator();
            keyGen.init(new KeyGenerationParameters(random, 192));
            return keyGen.generateKey();
        }
        throw new Exception("can not generate such key:" + contentEncryptionAlg);
    }

    public static byte[] generateIV() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[8];
        random.nextBytes(iv);
        return iv;
    }
}

