/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.common;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;
import shaded.cfca.sadk.algorithm.common.Mechanism;
import shaded.cfca.sadk.algorithm.common.PKCS7AttachSourceFile;
import shaded.cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.algorithm.util.BigIntegerUtil;
import shaded.cfca.sadk.asn1.parser.ASN1Node;
import shaded.cfca.sadk.asn1.parser.PKCS7SignFileParser;
import shaded.cfca.sadk.lib.crypto.Session;
import shaded.cfca.sadk.lib.crypto.jni.JNISoftLib;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import shaded.cfca.sadk.org.bouncycastle.asn1.BERSet;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERInteger;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERNull;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSet;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import shaded.cfca.sadk.signature.rsa.RSASignUtil;
import shaded.cfca.sadk.signature.sm2.SM2HashUtil;
import shaded.cfca.sadk.signature.sm2.SM2PackageUtil;
import shaded.cfca.sadk.signature.sm2.SM2SignerInfo;
import shaded.cfca.sadk.system.global.SM2ContextConfig;
import shaded.cfca.sadk.util.CertUtil;
import shaded.cfca.sadk.x509.certificate.X509Cert;

public class PKCS7SignedFile {
    private String digestAlgorithm;
    private byte[] signature;
    private byte[] sourceData;
    private X509Cert signerCert;
    private Session session = null;

    public PKCS7SignedFile(Session session) {
        this.session = session;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public X509Cert getSignerX509Cert() {
        return this.signerCert;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedFile(String signFile, String saveSrcFilePath) throws Exception {
        PKCS7SignFileParser parser = new PKCS7SignFileParser(new File(signFile));
        parser.parser();
        ASN1Node certificate_node = parser.getCertificate_node();
        ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
        if (CertUtil.isSM2Cert(new X509Cert(Certificate.getInstance(certSet.getObjectAt(0))))) {
            return this.verifySM2P7SignedFile(signFile, saveSrcFilePath, true, null, parser);
        }
        return this.verifyRSAP7SignedFile(signFile, saveSrcFilePath, parser);
    }

    private boolean verifySM2P7SignedFile(String signFile, String saveSrcFilePath, boolean ifZValue, byte[] userId, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                X509Cert signerCert;
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                this.signerCert = signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                this.digestAlgorithm = "SM3";
                this.signature = signature;
                this.sourceData = "source file is too big, will not display,please see the sourceFilePath attribute".getBytes("UTF8");
                byte[] hash = null;
                long valueStartPos = sourceData_node.valueStartPos;
                long valueLength = sourceData_node.valueLength;
                hash = ifZValue ? SM2HashUtil.hashFile(true, userId, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, pubKey, saveSrcFilePath, this.session) : SM2HashUtil.hashFile(false, null, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, null, saveSrcFilePath, this.session);
                if (this.session instanceof JNISoftLib) {
                    SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                    byte[] pubX = sm2PubKey.getPubXByBytes();
                    byte[] pubY = sm2PubKey.getPubYByBytes();
                    return SM2PackageUtil.verifyByJNI(hash, signature, pubX, pubY);
                }
                return SM2PackageUtil.verifyByBC(hash, signature, pubKey);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifyRSAP7SignedFile(String signFile, String saveSrcFilePath, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                this.signerCert = signerCert;
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                String signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = "MD5";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = "SHA-1";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = "SHA-256";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = "SHA-512";
                } else {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                this.digestAlgorithm = signM;
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                this.signature = signature;
                this.sourceData = "source file is too big, will not display".getBytes("UTF8");
                return RSASignUtil.verifySignFile(signM, pubKey, sourceData_node.f.getAbsolutePath(), sourceData_node.valueStartPos, sourceData_node.valueLength, signature, saveSrcFilePath);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    public void packageRSASignedFile(String contentType, String sourceFile, String signFile, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
            }
            DEROctetString encryptedData = new DEROctetString(signature);
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = null;
            String digestAlgorithm = mechanism.getMechanismType();
            if (digestAlgorithm.equals("md5WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
            } else if (digestAlgorithm.equals("sha1WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
            } else if (digestAlgorithm.equals("sha256WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, new DERNull());
            } else if (digestAlgorithm.equals("sha512WithRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, new DERNull());
            }
            SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            BERSet digestAlgorithmSets = new BERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1L), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void packageSM2SignedFile(String contentType, String sourceFile, String signFile, byte[] signature, X509Cert[] certs) throws PKIException {
        try {
            SM2SignerInfo signerInfo;
            if (certs == null) {
                throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
            }
            byte[] r = null;
            byte[] s = null;
            if ((signature[0] & 0x80) != 0) {
                r = new byte[33];
                r[0] = 0;
                System.arraycopy(signature, 0, r, 1, 32);
            } else {
                r = new byte[32];
                System.arraycopy(signature, 0, r, 0, 32);
            }
            if ((signature[32] & 0x80) != 0) {
                s = new byte[33];
                s[0] = 0;
                System.arraycopy(signature, 32, s, 1, 32);
            } else {
                s = new byte[32];
                System.arraycopy(signature, 32, s, 0, 32);
            }
            DERInteger derR = new DERInteger(r);
            DERInteger derS = new DERInteger(s);
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = null;
            AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, new DERNull());
            if (SM2ContextConfig.getSignFormat() == 3) {
                digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, new DERNull());
                signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            } else if (SM2ContextConfig.getSignFormat() == 2) {
                digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, new DERNull());
                signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            } else {
                digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm2Encryption, new DERNull());
                signerInfo = new SM2SignerInfo(new ASN1Integer(1L), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            }
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            DERSet digestAlgorithmSets = new DERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1L), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void packageSignedFile(String contentType, String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null) {
            throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
        }
        if (CertUtil.isSM2Cert(certs[0])) {
            this.packageSM2SignedFile(contentType, sourceFilePath, signFile, signture, certs);
        } else {
            this.packageRSASignedFile(contentType, sourceFilePath, signFile, signture, mechanism, certs);
        }
    }
}

