/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import java.io.IOException;
import org.apache.logging.log4j.core.util.Integers;
import shade.com.fasterxml.jackson.core.JsonParser;
import shade.com.fasterxml.jackson.core.JsonProcessingException;
import shade.com.fasterxml.jackson.core.JsonToken;
import shade.com.fasterxml.jackson.databind.DeserializationContext;
import shade.com.fasterxml.jackson.databind.JsonMappingException;
import shade.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public final class Log4jStackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public Log4jStackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = null;
            String methodName = null;
            String fileName = null;
            int lineNumber = -1;
            while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName = jp.getCurrentName();
                if ("class".equals(propName)) {
                    className = jp.getText();
                    continue;
                }
                if ("file".equals(propName)) {
                    fileName = jp.getText();
                    continue;
                }
                if ("line".equals(propName)) {
                    if (t.isNumeric()) {
                        lineNumber = jp.getIntValue();
                        continue;
                    }
                    try {
                        lineNumber = Integers.parseInt(jp.getText());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw JsonMappingException.from((JsonParser)jp, (String)("Non-numeric token (" + t + ") for property 'line'"), (Throwable)e);
                    }
                }
                if ("method".equals(propName)) {
                    methodName = jp.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw ctxt.mappingException(this._valueClass, t);
    }
}

