/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import io.netty.handler.ssl.SslContextBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class CertUtil {
    private static Logger log = LoggerFactory.getLogger(CertUtil.class);
    private static SslContextBuilder sslContextBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCertData(String filePath) throws Exception {
        File certFile = new File(filePath);
        if (!certFile.exists()) {
            return "";
        }
        String certContent = "";
        try (BufferedReader certIn = null;){
            String line;
            certIn = new BufferedReader(new FileReader(certFile));
            while ((line = certIn.readLine()) != null) {
                if (line.contains("BEGIN") || line.contains("END")) continue;
                certContent = certContent + line;
            }
        }
        return certContent;
    }

    public static void addProviders() throws Exception {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            if (Security.getProvider("BCJSSE") == null) {
                Security.addProvider(new BouncyCastleJsseProvider("BC"));
            }
        }
        catch (Exception e) {
            log.error("Providers added with error.");
            throw new Exception("Providers added with error.");
        }
    }
}

