/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.server.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import netbank.firm.config.CibProfile;
import netbank.firm.server.dto.SignOnRequest;
import netbank.firm.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class BaseService {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);

    protected static <T> T extraResponse(String body, String tagName, Class<T> clazz) throws Exception {
        Document document = XmlUtil.parse(body);
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        return XmlUtil.toObject(nodeList.item(0), clazz);
    }

    protected static SignOnRequest getCommonSignOn(CibProfile profile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:dd:mm");
        SignOnRequest request = new SignOnRequest();
        request.setClientDateTime(dateFormat.format(new Date()));
        request.setNcid(profile.getNcid());
        request.setAppId("XYFIB");
        request.setAppVersion("1000");
        request.setGenerateKey("N");
        request.setUserId("xxx");
        request.setUserKey("xxx");
        request.setPassword("xxx");
        return request;
    }
}

