/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.serial.tool;

import netbank.firm.model.AbstractMessageHead;
import netbank.firm.model.BizType;
import netbank.firm.model.EncryptKeyModel;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.SerializableMessage;
import netbank.firm.model.SimpleHead;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.model.gmmodel.GmMessageHeadV2;
import netbank.firm.model.gmmodel.GmSimpleHead;
import netbank.firm.serial.HeadType;
import netbank.firm.serial.ReflectSerial;
import netbank.firm.serial.Serialable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageWrapper {
    public static Object unwrap(Message message) throws Exception {
        AbstractMessageHead<?> head = message.getHead();
        if (MessageType.MESSAGE == message.getMessageType()) {
            BizType bt = null;
            if (message.getHead() instanceof MessageHead) {
                bt = ((MessageHead)head).getBizType();
            } else if (message.getHead() instanceof GmMessageHead) {
                bt = ((GmMessageHead)head).getBizType();
            } else if (message.getHead() instanceof GmMessageHeadV2) {
                bt = ((GmMessageHeadV2)head).getBizType();
            }
            return ReflectSerial.bytes2Object(head.getMagicNum(), bt, message.getBody());
        }
        return ReflectSerial.bytes2Object(head.getMagicNum(), null, message.getBody());
    }

    public static Message wrap(SerializableMessage<?> object) throws Exception {
        Message mess = new Message();
        Class<?> cls = Class.forName(object.getClass().getName());
        byte[] body = object.tobytes();
        mess.setBody(body);
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (HeadType.Message == annoCls.headType()) {
            MessageHead mh = new MessageHead();
            mh.setCompress(annoCls.outCompress());
            mh.setBizType(annoCls.txnModel().getBt());
            mh.setMagicNum(annoCls.txnModel().getMn());
            mh.setLength(body.length);
            mess.setMessageType(MessageType.MESSAGE);
            mess.setHead(mh);
            if (object instanceof EncryptKeyModel) {
                String key = ((EncryptKeyModel)((Object)object)).getKey();
                if (key != null && !"".equals(key)) {
                    mh.setEncrypt(true);
                    mh.setKey(key);
                } else {
                    mh.setEncrypt(false);
                }
            }
        } else if (HeadType.GmMessage == annoCls.headType()) {
            GmMessageHead mh = new GmMessageHead();
            mh.setCompress(annoCls.outCompress());
            mh.setBizType(annoCls.txnModel().getBt());
            mh.setMagicNum(annoCls.txnModel().getMn());
            mh.setLength(body.length);
            mess.setMessageType(MessageType.MESSAGE);
            mess.setHead(mh);
            if (object instanceof EncryptKeyModel) {
                String key = ((EncryptKeyModel)((Object)object)).getKey();
                if (key != null && !"".equals(key)) {
                    mh.setEncrypt(true);
                    mh.setKey(key);
                } else {
                    mh.setEncrypt(false);
                }
            }
        } else if (HeadType.GmMessageV2 == annoCls.headType()) {
            GmMessageHeadV2 mh = new GmMessageHeadV2();
            mh.setCompress(annoCls.outCompress());
            mh.setBizType(annoCls.txnModel().getBt());
            mh.setMagicNum(annoCls.txnModel().getMn());
            mh.setLength(body.length);
            mess.setMessageType(MessageType.MESSAGE);
            mess.setHead(mh);
            if (object instanceof EncryptKeyModel) {
                String key = ((EncryptKeyModel)((Object)object)).getKey();
                if (key != null && !"".equals(key)) {
                    mh.setEncrypt(true);
                    mh.setKey(key);
                } else {
                    mh.setEncrypt(false);
                }
            }
        } else if (HeadType.SimpMessage == annoCls.headType()) {
            SimpleHead fh = new SimpleHead();
            fh.setMagicNum(annoCls.txnModel().getMn());
            fh.setLength(body.length);
            mess.setMessageType(MessageType.FILE);
            mess.setHead(fh);
        } else if (HeadType.GmSimpMessage == annoCls.headType()) {
            GmSimpleHead fh = new GmSimpleHead();
            fh.setMagicNum(annoCls.txnModel().getMn());
            fh.setLength(body.length);
            mess.setMessageType(MessageType.FILE);
            mess.setHead(fh);
        }
        return mess;
    }
}

