/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.serial.tool;

import netbank.firm.base.ByteUtils;
import netbank.firm.serial.AlignType;
import netbank.firm.serial.CodeType;
import netbank.firm.serial.FieldDefine;
import netbank.firm.serial.SerialInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSerial
implements SerialInterface<Integer> {
    @Override
    public String object2String(FieldDefine define, Integer value) {
        Integer val = value == null ? 0 : value;
        StringBuffer orignal = new StringBuffer(val.toString());
        if (define.align() == AlignType.LEFT) {
            for (int i = 0; i < define.length() - val.toString().length(); ++i) {
                orignal.append(" ");
            }
        } else {
            for (int i = 0; i < define.length() - val.toString().length(); ++i) {
                orignal.insert(0, " ");
            }
        }
        return orignal.toString();
    }

    @Override
    public Integer string2Object(String str) {
        return new Integer(str.trim());
    }

    @Override
    public Integer bytes2Object(byte[] str) {
        String value = new String(str);
        return new Integer(value.trim());
    }

    @Override
    public byte[] object2bytes(FieldDefine define, Integer value) {
        if (CodeType.Ascii == define.codType()) {
            return this.object2String(define, value).getBytes();
        }
        if (define.length() == 4) {
            return ByteUtils.int2byte(value);
        }
        if (define.length() == 2) {
            return ByteUtils.short2byte(value);
        }
        throw new RuntimeException("integer FieldDefine length is wrong");
    }
}

