/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.serial.tool;

import java.math.BigDecimal;
import netbank.firm.serial.AlignType;
import netbank.firm.serial.FieldDefine;
import netbank.firm.serial.SerialInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalSerial
implements SerialInterface<BigDecimal> {
    @Override
    public String object2String(FieldDefine define, BigDecimal value) {
        String original;
        String string = original = value == null ? "0" : value.toPlainString();
        if (original.length() > define.length()) {
            throw new NumberFormatException();
        }
        if (value.scale() > 0) {
            StringBuffer dig = new StringBuffer(original.substring(original.indexOf(".")));
            StringBuffer head = new StringBuffer(original.substring(0, original.indexOf(".")));
            if (head.length() > define.length() - 1 - define.precision()) {
                throw new NumberFormatException("length define too short");
            }
            if (define.precision() > dig.length() - 1) {
                for (int i = 0; i < define.precision() - dig.length() + 1; ++i) {
                    dig.append("0");
                }
            } else {
                dig = define.precision() > 0 ? new StringBuffer(dig.substring(0, define.precision() + 1)) : new StringBuffer(dig.substring(0, define.precision()));
            }
            head.append(dig);
            int j = define.length() - head.length();
            if (define.align() == AlignType.LEFT) {
                for (int i = 0; i < j; ++i) {
                    head.append(" ");
                }
            } else {
                for (int i = 0; i < j; ++i) {
                    head.insert(0, " ");
                }
            }
            return head.toString();
        }
        StringBuffer result = new StringBuffer(original);
        if (define.align() == AlignType.LEFT) {
            for (int i = 0; i < define.length() - original.length(); ++i) {
                result.append(" ");
            }
        } else {
            for (int i = 0; i < define.length() - original.length(); ++i) {
                result.insert(0, " ");
            }
        }
        return result.toString();
    }

    @Override
    public BigDecimal string2Object(String str) {
        return new BigDecimal(str.trim());
    }

    @Override
    public BigDecimal bytes2Object(byte[] str) {
        return this.string2Object(new String(str));
    }

    @Override
    public byte[] object2bytes(FieldDefine define, BigDecimal value) {
        return this.object2String(define, value).getBytes();
    }
}

