/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import netbank.firm.base.SystemProperty;
import netbank.firm.handler.AbstractNotifyMessageHandler4SDK;
import netbank.firm.handler.AbstractRequestFileHandler4SDK;
import netbank.firm.model.AbstractMessage;
import netbank.firm.model.FileRequest;
import netbank.firm.model.Request;
import netbank.firm.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTypeHandler
extends SimpleChannelInboundHandler<AbstractMessage> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, AbstractMessage msg) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        if (msg instanceof FileRequest) {
            String requestFileHandlerClassName = SystemProperty.getInstance().getProperty("notify.file.handler", true);
            AbstractRequestFileHandler4SDK requestFileHandler = (AbstractRequestFileHandler4SDK)ReflectUtil.getInstance(requestFileHandlerClassName);
            requestFileHandler.setPath(SystemProperty.getInstance().getProperty("file.receive.path", true));
            p.addBefore("idleState", "reciveFile", requestFileHandler);
        }
        if (msg instanceof Request) {
            String notifyMessageHandlerClassName = SystemProperty.getInstance().getProperty("notify.message.handler", true);
            AbstractNotifyMessageHandler4SDK notifyMessageHandler = (AbstractNotifyMessageHandler4SDK)ReflectUtil.getInstance(notifyMessageHandlerClassName);
            p.addBefore("idleState", "echoHandler", notifyMessageHandler);
        }
        ctx.fireChannelRead(msg);
    }
}

