/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.gm.constant;

import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColumnType {
    BYTE{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            Number n = (Number)obj;
            byteBuffer.put(n.byteValue());
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.get();
        }
    }
    ,
    BYTE_ARRAY{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            Short len = byteBuffer.getShort();
            byte[] bytes = new byte[len.shortValue()];
            byteBuffer.get(bytes);
            return bytes;
        }
    }
    ,
    FIX_BYTE_ARRAY_8{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[8];
            byteBuffer.get(bytes);
            return bytes;
        }
    }
    ,
    FIX_BYTE_ARRAY_32{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[32];
            byteBuffer.get(bytes);
            return bytes;
        }
    }
    ,
    SHORT{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            Number n = (Number)obj;
            byteBuffer.putShort(n.shortValue());
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getShort();
        }
    }
    ,
    STRING{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.putShort((short)bytes.length);
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            short len = byteBuffer.getShort();
            if (len > 0) {
                byte[] bytes = new byte[len];
                byteBuffer.get(bytes);
                return bytes;
            }
            return null;
        }
    }
    ,
    LONG_STRING{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.putInt(bytes.length);
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            int len = byteBuffer.getInt();
            if (len > 0) {
                byte[] bytes = new byte[len];
                byteBuffer.get(bytes);
                return bytes;
            }
            return null;
        }
    }
    ,
    NOLEN_STRING{

        public void serialize(ByteBuffer byteBuffer, Object obj) {
            byte[] bytes = (byte[])obj;
            byteBuffer.put(bytes);
        }

        public Object deserialize(ByteBuffer byteBuffer) {
            return null;
        }
    };


    public abstract void serialize(ByteBuffer var1, Object var2);

    public abstract Object deserialize(ByteBuffer var1);
}

