/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.gm;

import javax.annotation.Resource;
import netbank.firm.exception.DcfirmException;
import netbank.firm.gm.HsmService;
import netbank.firm.gm.protocol.resp.SM2DecryptResp;
import netbank.firm.gm.protocol.resp.SM4DecryptResp;
import netbank.firm.gm.protocol.resp.SM4EncryptResp;

public class SMService {
    public static final String SM2_PREFIX = "{SM2}";
    public static final String SM4_PREFIX = "{SM4}";
    public static final String DES_PREFIX = "{DES}";
    @Resource
    private HsmService hsmService;

    public String SM4Decrypt(String sm4EncText) throws DcfirmException {
        SM4DecryptResp resp = this.hsmService.SM4Decrypt(sm4EncText);
        sm4EncText = new String(resp.getDecText());
        return sm4EncText;
    }

    public String calSM4Password(String encText) throws DcfirmException {
        if (!encText.startsWith(SM4_PREFIX)) {
            byte[] protocol = this.hsmService.constructProtocol(encText);
            SM4EncryptResp resp = this.hsmService.SM4Encrypt(protocol);
            encText = resp.getBase64String();
        }
        return encText;
    }

    public String decrypt(String encText) throws Exception {
        SM2DecryptResp sm2DecryptResp = this.hsmService.SM2Decrypt(encText);
        encText = new String(sm2DecryptResp.getDecText());
        return encText;
    }
}

