/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.exception;

import netbank.firm.base.SystemProperty;
import netbank.firm.exception.ExceptionCode;

public class DcfirmRTException
extends RuntimeException {
    private static final long serialVersionUID = 4238510821324206056L;
    private String code;
    private String message;

    public DcfirmRTException() {
        super(ExceptionCode.UNKNOWN.getErrmsg());
        this.code = ExceptionCode.UNKNOWN.getCode();
        this.message = ExceptionCode.UNKNOWN.getErrmsg();
    }

    public DcfirmRTException(ExceptionCode code) {
        super(code.getErrmsg());
        this.code = code.getCode();
        this.message = code.getErrmsg();
    }

    public DcfirmRTException(ExceptionCode code, Throwable throwable) {
        super(code.getErrmsg(), throwable);
        this.code = code.getCode();
        this.message = code.getErrmsg();
    }

    public DcfirmRTException(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public DcfirmRTException(String code, String message, Throwable throwable) {
        super(message, throwable);
        this.code = code;
        this.message = message;
    }

    public String getErrCode() {
        return SystemProperty.getInstance().getSysName() + "_" + this.code;
    }

    public String getErrmsg() {
        return this.message;
    }

    public String toString() {
        return "DcfirmRTException code=[" + this.getErrCode() + "],error message=[" + this.message + "]";
    }

    public String getMessage() {
        return this.toString();
    }

    public static void main(String[] args) {
        System.out.println(ExceptionCode.valueOf("UNKNOWN").getCode());
    }
}

