/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.dispatcher;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.AbstractMessageHead;
import netbank.firm.model.BizType;
import netbank.firm.model.MagicNum;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.ProtocolVersion;
import netbank.firm.model.SimpleHead;
import netbank.firm.model.gmmodel.GmMessageHead;
import netbank.firm.model.gmmodel.GmMessageHeadV2;
import netbank.firm.model.gmmodel.GmSimpleHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoderDispatcher
extends ReplayingDecoder<DecoderState> {
    protected static final Logger LOG = LoggerFactory.getLogger(DecoderDispatcher.class);
    private Message msg = null;
    private ProtocolVersion version;
    private MagicNum magic;
    private BizType bizType;
    private int length;
    private Boolean encrpt;
    private Boolean compress;
    private String md;
    private String key;
    private int sm3SignLength;
    private String sm3Sign;
    private byte[] content;
    private MessageType mt;

    public DecoderDispatcher() {
        super(DecoderState.READ_MAGIC);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_MAGIC: {
                this.magic = MagicNum.valueOf(in.readByte());
                switch (this.magic) {
                    case _0x12: {
                        LOG.info("\u3010\u5ba2\u6237\u8bf7\u6c42\u3011\u901a\u9053id\uff1a" + ctx.channel().id() + "\u7684\u7b2c\u4e00\u4e2a\u89e3\u7801\u5668\uff0c\u6536\u5230\u5b57\u8282\u6d41\u5e76\u89e3\u7801\u4e3aMessage\u7c7b");
                        LOG.info("\u3010\u5ba2\u6237\u8bf7\u6c42\u3011\u9b54\u6570\u503c\uff1a" + this.magic.toString() + " \u5f00\u59cb\u5bf9\u5b57\u8282\u6d41\u8fdb\u884c\u89e3\u7801......");
                        this.checkpoint(DecoderState.READ_VERSION);
                        this.mt = MessageType.MESSAGE;
                        break;
                    }
                    case _0x15: 
                    case _0x19: {
                        this.checkpoint(DecoderState.READ_LENGTH);
                        this.mt = MessageType.FILE;
                        return;
                    }
                    case _0x13: 
                    case _0x14: {
                        LOG.info("\u3010\u94f6\u884c\u54cd\u5e94\u3011\u901a\u9053id\uff1a" + ctx.channel().id() + " \u7684\u7b2c\u4e00\u4e2a\u89e3\u7801\u5668\uff0c\u6536\u5230\u5b57\u8282\u6d41\u5e76\u89e3\u7801\u4e3aMessage\u7c7b");
                        LOG.info("\u3010\u94f6\u884c\u54cd\u5e94\u3011\u9b54\u6570\u503c\uff1a" + this.magic.toString() + " \u5f00\u59cb\u5bf9\u5b57\u8282\u6d41\u8fdb\u884c\u89e3\u7801......");
                        this.checkpoint(DecoderState.READ_VERSION);
                        this.mt = MessageType.MESSAGE;
                        break;
                    }
                    case _0x16: 
                    case _0x17: 
                    case _0x20: 
                    case _0x21: {
                        this.checkpoint(DecoderState.READ_LENGTH);
                        this.mt = MessageType.FILE;
                        return;
                    }
                    case _0x18: {
                        this.checkpoint(DecoderState.READ_LENGTH);
                        this.mt = MessageType.SYSERR;
                        return;
                    }
                    default: {
                        LOG.error("\u901a\u9053id\uff1a" + ctx.channel().id() + " \u9b54\u6570\u503c\uff1a" + Integer.toHexString(in.readByte() & 0xFF));
                        throw new DcfirmException(ExceptionCode.B100);
                    }
                }
            }
            case READ_VERSION: {
                this.version = ProtocolVersion.valueOf(in.readByte());
                if (this.version != ProtocolVersion.VER1 && this.version != ProtocolVersion.VER2 && this.version != ProtocolVersion.VER3) {
                    throw new DcfirmException(ExceptionCode.B100);
                }
                this.checkpoint(DecoderState.READ_BIZ_TYPE);
            }
            case READ_BIZ_TYPE: {
                this.bizType = BizType.valueOf(in.readByte());
                if (this.bizType == BizType.UNSUPPORT) {
                    throw new DcfirmException(ExceptionCode.B101);
                }
                this.checkpoint(DecoderState.READ_COMPRESS);
            }
            case READ_COMPRESS: {
                this.compress = in.readBoolean();
                this.checkpoint(DecoderState.READ_ENCRPT);
            }
            case READ_ENCRPT: {
                this.encrpt = in.readBoolean();
                this.checkpoint(DecoderState.READ_MD);
            }
            case READ_MD: {
                byte[] mdbytes;
                if (this.version == ProtocolVersion.VER1) {
                    mdbytes = new byte[32];
                    in.readBytes(mdbytes, 0, 32);
                    this.md = new String(mdbytes);
                } else if (this.version == ProtocolVersion.VER2 || this.version == ProtocolVersion.VER3) {
                    mdbytes = new byte[64];
                    in.readBytes(mdbytes, 0, 64);
                    this.md = new String(mdbytes);
                }
                this.checkpoint(DecoderState.READ_KEY);
            }
            case READ_KEY: {
                byte[] keybytes = new byte[16];
                in.readBytes(keybytes, 0, 16);
                this.key = new String(keybytes);
                this.checkpoint(DecoderState.READ_LENGTH);
            }
            case READ_LENGTH: {
                this.length = in.readShort();
                this.checkpoint(DecoderState.READ_SM3SIGN_LENGTH);
            }
            case READ_SM3SIGN_LENGTH: {
                if (this.version == ProtocolVersion.VER3) {
                    this.sm3SignLength = in.readShort();
                }
                this.checkpoint(DecoderState.READ_SM3SIGNATURE);
            }
            case READ_SM3SIGNATURE: {
                if (this.version == ProtocolVersion.VER3) {
                    byte[] sm3SignBytes = new byte[this.sm3SignLength];
                    in.readBytes(sm3SignBytes, 0, this.sm3SignLength);
                    this.sm3Sign = new String(sm3SignBytes);
                }
                this.checkpoint(DecoderState.READ_CONTENT);
            }
            case READ_CONTENT: {
                this.content = new byte[this.length];
                in.readBytes(this.content, 0, this.length);
                AbstractMessageHead<?> head = this.newHead();
                this.msg = new Message(this.mt, head, this.content);
                break;
            }
        }
        this.reset();
        if (this.msg == null) {
            ctx.channel().closeFuture().sync();
            return;
        }
        out.add(this.msg);
        LOG.info("\u7b2c\u4e00\u4e2a\u89e3\u6790\u5668\u89e3\u6790\u5b8c\u6bd5\uff01");
    }

    private void reset() {
        this.magic = null;
        this.bizType = null;
        this.length = 0;
        this.encrpt = null;
        this.compress = null;
        this.md = null;
        this.content = null;
        this.mt = null;
        this.key = null;
        this.sm3Sign = null;
        this.sm3SignLength = 0;
        this.checkpoint(DecoderState.READ_MAGIC);
    }

    private AbstractMessageHead<?> newHead() {
        switch (this.magic) {
            case _0x12: 
            case _0x13: 
            case _0x14: {
                if (ProtocolVersion.VER1 == this.version) {
                    MessageHead messageHead = new MessageHead();
                    messageHead.setMagicNum(this.magic);
                    messageHead.setVersion(this.version);
                    messageHead.setBizType(this.bizType);
                    messageHead.setCompress(this.compress);
                    messageHead.setEncrypt(this.encrpt);
                    messageHead.setKey(this.key);
                    messageHead.setLength(this.length);
                    messageHead.setMd(this.md);
                    return messageHead;
                }
                if (ProtocolVersion.VER2 == this.version) {
                    GmMessageHead gmMessageHead = new GmMessageHead();
                    gmMessageHead.setMagicNum(this.magic);
                    gmMessageHead.setVersion(this.version);
                    gmMessageHead.setBizType(this.bizType);
                    gmMessageHead.setCompress(this.compress);
                    gmMessageHead.setEncrypt(this.encrpt);
                    gmMessageHead.setKey(this.key);
                    gmMessageHead.setLength(this.length);
                    gmMessageHead.setMd(this.md);
                    return gmMessageHead;
                }
                if (ProtocolVersion.VER3 == this.version) {
                    GmMessageHeadV2 gmMessageHead = new GmMessageHeadV2();
                    gmMessageHead.setMagicNum(this.magic);
                    gmMessageHead.setVersion(this.version);
                    gmMessageHead.setBizType(this.bizType);
                    gmMessageHead.setCompress(this.compress);
                    gmMessageHead.setEncrypt(this.encrpt);
                    gmMessageHead.setKey(this.key);
                    gmMessageHead.setLength(this.length);
                    gmMessageHead.setMd(this.md);
                    gmMessageHead.setSm3SignLength(this.sm3SignLength);
                    gmMessageHead.setSm3Signature(this.sm3Sign);
                    return gmMessageHead;
                }
            }
            case _0x15: 
            case _0x19: 
            case _0x16: 
            case _0x17: 
            case _0x20: 
            case _0x21: {
                if (ProtocolVersion.VER1 == this.version) {
                    SimpleHead head = new SimpleHead();
                    head.setMagicNum(this.magic);
                    head.setLength(this.length);
                    return head;
                }
                if (ProtocolVersion.VER2 == this.version) {
                    GmSimpleHead head = new GmSimpleHead();
                    head.setMagicNum(this.magic);
                    head.setLength(this.length);
                    return head;
                }
            }
            case _0x18: {
                SimpleHead head = new SimpleHead();
                head.setMagicNum(this.magic);
                head.setLength(this.length);
                return head;
            }
        }
        return null;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error(cause.getMessage(), cause);
        super.exceptionCaught(ctx, cause);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DecoderState {
        READ_MAGIC,
        READ_VERSION,
        READ_BIZ_TYPE,
        READ_COMPRESS,
        READ_ENCRPT,
        READ_MD,
        READ_KEY,
        READ_LENGTH,
        READ_SM3SIGN_LENGTH,
        READ_SM3SIGNATURE,
        READ_CONTENT;

    }
}

