/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.dispatch;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import netbank.firm.config.CibProfile;
import netbank.firm.dispatch.SslTypeEnum;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.handler.FileServerNoMBFEChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServerDispatcher {
    private static Logger log = LoggerFactory.getLogger(FileServerDispatcher.class);
    public static final String SSL_FUTURE_KEY = "SSL_FUTURE_KEY";

    public static Channel connectRemoteServer(NioEventLoopGroup group, CibProfile cibProfile) throws Exception {
        return FileServerDispatcher.connectRemoteServer(group, cibProfile, SslTypeEnum.SM);
    }

    private static Channel connectRemoteServer(NioEventLoopGroup group, CibProfile cibProfile, SslTypeEnum sslTypeEnum) throws Exception {
        Future sslFuture;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new FileServerNoMBFEChannelInitializer(cibProfile, sslTypeEnum))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, cibProfile.getConnectionTimeOut() * 1000);
        ChannelFuture connectFuture = bootstrap.connect(cibProfile.getBankHost(), cibProfile.getBankPort()).sync();
        if (!connectFuture.isSuccess()) {
            log.error("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + cibProfile.getBankHost() + ":" + cibProfile.getBankHost() + "\u8fde\u63a5\u5931\u8d25", connectFuture.cause());
            throw new DcfirmException(ExceptionCode.C001);
        }
        Channel outboundChannel = connectFuture.channel();
        log.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a3.\u7f51\u7edc\u8fde\u63a5:" + cibProfile.getBankHost() + ":" + cibProfile.getBankHost() + "\u8fde\u63a5\u6210\u529f");
        log.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:\u5efa\u7acbssl [{}] \u901a\u9053\u4e2d\u2026\u2026", (Object)sslTypeEnum);
        AttributeKey sslFutureKey = AttributeKey.valueOf(SSL_FUTURE_KEY);
        Attribute sslFutureValue = outboundChannel.attr(sslFutureKey);
        Future future = sslFuture = sslFutureValue == null ? null : (Future)sslFutureValue.get();
        if (null == sslFuture) {
            throw new DcfirmException(ExceptionCode.S004);
        }
        try {
            sslFuture.sync();
        }
        catch (Exception e) {
            outboundChannel.close();
            log.warn("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:\u5efa\u7acbssl [{}] \u901a\u9053\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)sslTypeEnum, (Object)e);
            if (SslTypeEnum.SM.equals((Object)sslTypeEnum)) {
                log.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:ssl\u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u964d\u7ea7\u6210\u56fd\u9645\u901a\u9053");
                return FileServerDispatcher.connectRemoteServer(group, cibProfile, SslTypeEnum.INT);
            }
            throw new DcfirmException(ExceptionCode.C001, (Throwable)e);
        }
        if (!sslFuture.isSuccess()) {
            outboundChannel.close();
            log.warn("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:ssl [{}] \u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)sslTypeEnum, (Object)sslFuture.cause());
            if (SslTypeEnum.SM.equals((Object)sslTypeEnum)) {
                log.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:ssl\u901a\u9053\u5efa\u7acb\u5931\u8d25\uff0c\u964d\u7ea7\u6210\u56fd\u9645\u901a\u9053");
                return FileServerDispatcher.connectRemoteServer(group, cibProfile, SslTypeEnum.INT);
            }
            throw new DcfirmException(ExceptionCode.C001, sslFuture.cause());
        }
        log.info("\u8fd0\u8425\u53c2\u8003\u65e5\u5fd7\uff1a4.\u5efa\u7acbssl\u901a\u9053:\u5efa\u7acbssl [{}] \u901a\u9053\u6210\u529f", (Object)sslTypeEnum);
        return outboundChannel;
    }
}

