/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.config;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import netbank.firm.config.CibProfile;
import netbank.firm.server.dto.QueryDcConfigResponseBean;
import netbank.firm.server.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;

public class Config {
    private static Logger log = LoggerFactory.getLogger(Config.class);
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("CONFIG-pool");
    private static ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, THREAD_FACTORY);
    private static final long DEGRADE_LIMIT_TIME = 600L;
    private String sm2PublicKeyX;
    private String sm2PublicKeyY;

    public String getSm2PublicKeyX() {
        return this.sm2PublicKeyX;
    }

    public void setSm2PublicKeyX(String sm2PublicKeyX) {
        this.sm2PublicKeyX = sm2PublicKeyX;
    }

    public String getSm2PublicKeyY() {
        return this.sm2PublicKeyY;
    }

    public void setSm2PublicKeyY(String sm2PublicKeyY) {
        this.sm2PublicKeyY = sm2PublicKeyY;
    }

    public static Config getInstance() {
        return ConfigHolder.CONFIG;
    }

    public static void startTask(final CibProfile profile) {
        Config.stopTask();
        SCHEDULED_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, THREAD_FACTORY);
        SCHEDULED_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Config.queryConfig(profile);
            }
        }, 600L, 600L, TimeUnit.SECONDS);
    }

    public static void stopTask() {
        if (!SCHEDULED_EXECUTOR_SERVICE.isShutdown()) {
            SCHEDULED_EXECUTOR_SERVICE.shutdown();
        }
    }

    private static void queryConfig(CibProfile profile) {
        try {
            log.info("query Config Data begin ......");
            QueryDcConfigResponseBean.ResponseBody responseBody = ConfigService.queryConfig(profile);
            if (StringUtils.isEmpty(responseBody.getSm2PublicKeyX()) || StringUtils.isEmpty(responseBody.getSm2PublicKeyY())) {
                log.warn("queryConfig data error .......");
                return;
            }
            Config.getInstance().setSm2PublicKeyX(responseBody.getSm2PublicKeyX());
            Config.getInstance().setSm2PublicKeyY(responseBody.getSm2PublicKeyY());
            log.info("query Config Data end ......");
        }
        catch (Exception e) {
            log.warn("queryConfig error:", e);
        }
    }

    private static class ConfigHolder {
        private static final Config CONFIG = new Config();

        private ConfigHolder() {
        }
    }
}

