/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import shade.org.apache.commons.lang.StringUtils;

public class Util {
    public static final String LOG_MSG_TYPE = "LOG_MSG_TYPE";
    public static final String LOG_START_TIME = "LOG_START_TIME";
    public static final String LOG_FILE_SIZE = "LOG_FILE_SIZE";
    public static final String LOG_NCID = "LOG_NCID";
    public static final String DOWNLOAD_SUCCESS_FLAG = "DOWNLOAD_SUCCESS_FLAG";
    public static final String SUCCESS_FLAG = "0";
    private static final Logger STATISTIC_INFO_LOG = LoggerFactory.getLogger("service.statistic.info.log");
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    public static String stringSplice(String separator, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String str : args) {
            str = StringUtils.trimToEmpty(str);
            sb.append(str);
            sb.append(separator);
        }
        return sb.toString();
    }

    public static void printSysErrorLog(String msg) {
        if (!SUCCESS_FLAG.equals(MDC.get(DOWNLOAD_SUCCESS_FLAG))) {
            Util.printAppErrorLog(msg);
        }
    }

    public static void printAppErrorLog(String msg) {
        Date endTime = new Date();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (STATISTIC_INFO_LOG.isInfoEnabled()) {
            try {
                STATISTIC_INFO_LOG.info(Util.stringSplice("|", MDC.get(LOG_MSG_TYPE), MDC.get(LOG_NCID), MDC.get(LOG_START_TIME), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(endTime), MDC.get(LOG_START_TIME) == null ? "" : endTime.getTime() - new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(MDC.get(LOG_START_TIME)).getTime() + "ms", MDC.get(LOG_FILE_SIZE), "FAIL", msg, operatingSystemMXBean instanceof UnixOperatingSystemMXBean ? "File Handle:" + ((UnixOperatingSystemMXBean)operatingSystemMXBean).getOpenFileDescriptorCount() : "File Handle:"));
            }
            catch (ParseException e) {
                LOG.error("\u8bb0\u5f55\u76d1\u63a7\u65e5\u5fd7\u5931\u8d25,\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38");
            }
        }
    }

    public static void printSuccessLog() {
        Date endTime = new Date();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (STATISTIC_INFO_LOG.isInfoEnabled()) {
            try {
                STATISTIC_INFO_LOG.info(Util.stringSplice("|", MDC.get(LOG_MSG_TYPE), MDC.get(LOG_NCID), MDC.get(LOG_START_TIME), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(endTime), MDC.get(LOG_START_TIME) == null ? "" : endTime.getTime() - new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(MDC.get(LOG_START_TIME)).getTime() + "ms", MDC.get(LOG_FILE_SIZE), "SUCCESS", "\u6210\u529f", operatingSystemMXBean instanceof UnixOperatingSystemMXBean ? "File Handle:" + ((UnixOperatingSystemMXBean)operatingSystemMXBean).getOpenFileDescriptorCount() : "File Handle:"));
            }
            catch (ParseException e) {
                LOG.error("\u8bb0\u5f55\u76d1\u63a7\u65e5\u5fd7\u5931\u8d25,\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38");
            }
        }
    }
}

