/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import com.cib.smtools.security.CommonUtils;
import com.cib.smtools.security.SMS4;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import netbank.firm.base.Base64;
import netbank.firm.base.Base64Cap4j;
import netbank.firm.base.ConvertUtil;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.DownloadErrorResponse;
import netbank.firm.model.DownloadRequest;
import netbank.firm.model.DownloadResponse;
import netbank.firm.model.FileRequest;
import netbank.firm.model.FileResponse;
import netbank.firm.model.UploadErrorResponse;
import netbank.firm.model.UploadRequest;
import netbank.firm.model.UploadResponse;
import netbank.firm.model.gmmodel.GmDownloadErrorResponse;
import netbank.firm.model.gmmodel.GmDownloadRequest;
import netbank.firm.model.gmmodel.GmDownloadRequestV2;
import netbank.firm.model.gmmodel.GmDownloadResponse;
import netbank.firm.model.gmmodel.GmUploadErrorResponse;
import netbank.firm.model.gmmodel.GmUploadRequest;
import netbank.firm.model.gmmodel.GmUploadRequestV2;
import netbank.firm.model.gmmodel.GmUploadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.bouncycastle.asn1.gm.GMNamedCurves;
import shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.org.bouncycastle.crypto.digests.SM3Digest;
import shaded.org.bouncycastle.crypto.engines.SM2Engine;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.util.encoders.Hex;

public class GMUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(GMUtils.class);
    private static String PREFIX = "{SM2}";

    public static String sm3DigestGen(byte[] data) {
        byte[] md = null;
        try {
            SM3Digest sm3Digest = new SM3Digest();
            sm3Digest.update(data, 0, data.length);
            md = new byte[sm3Digest.getDigestSize()];
            sm3Digest.doFinal(md, 0);
            return Hex.toHexString(md);
        }
        catch (Exception var3) {
            LOG.error("SM3 Ecrypt Error:", var3);
            return null;
        }
    }

    public static String sm3DigestGen(File file) throws Exception {
        if (file == null || !file.exists() || !file.isFile()) {
            LOG.error("sm3DigestGen check error: file is invalid");
            return null;
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        byte[] block = new byte[0x100000];
        FileInputStream in = null;
        try {
            int readLength;
            in = new FileInputStream(file);
            SM3Digest sm3Digest = new SM3Digest();
            while ((readLength = in.read(block)) != -1) {
                sm3Digest.update(block, 0, readLength);
            }
            byte[] hash = new byte[sm3Digest.getDigestSize()];
            sm3Digest.doFinal(hash, 0);
            String string = Hex.toHexString(hash);
            return string;
        }
        catch (Exception e) {
            LOG.error("sm3DigestGen error:", e);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static byte[] sm4Decrypt(byte[] strValue, String keystr) {
        if (strValue != null) {
            byte[] in = Base64Cap4j.decode(strValue);
            int inLen = in.length;
            byte[] out = new byte[inLen];
            String key64str = new String(Base64.encode(keystr.getBytes()));
            byte[] keyin = key64str.getBytes();
            for (int newkeyin = keyin.length % 16; newkeyin < 16; ++newkeyin) {
                key64str = key64str + " ";
            }
            byte[] var10 = key64str.getBytes();
            SMS4 sms4 = new SMS4();
            sms4.sms4(in, inLen, var10, out, 0);
            return Base64Cap4j.decode(out);
        }
        return null;
    }

    public static byte[] sm4Encrypt(byte[] strValue, String keystr) {
        if (strValue != null) {
            int newIn;
            String base64Str = new String(Base64.encode(strValue));
            String key64str = new String(Base64.encode(keystr.getBytes()));
            byte[] in = base64Str.getBytes();
            byte[] keyin = key64str.getBytes();
            for (newIn = in.length % 16; newIn < 16; ++newIn) {
                base64Str = base64Str + " ";
            }
            for (newIn = keyin.length % 16; newIn < 16; ++newIn) {
                key64str = key64str + " ";
            }
            byte[] var12 = base64Str.getBytes();
            byte[] newkeyin = key64str.getBytes();
            int inLen = var12.length;
            byte[] out = new byte[inLen];
            SMS4 sms4 = new SMS4();
            sms4.sms4(var12, inLen, newkeyin, out, 1);
            return Base64Cap4j.encode(out);
        }
        return null;
    }

    public static String sm2Encrypt(String plainText, String key) throws Exception {
        key = "04" + key;
        plainText = ConvertUtil.constructProtocol(plainText);
        byte[] dataDateByte = plainText.getBytes();
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName("sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(CommonUtils.hexString2byte(key));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = sm2Engine.processBlock(dataDateByte, 0, dataDateByte.length);
        String cipherText = CommonUtils.byteToHex2(arrayOfBytes);
        int length = cipherText.length();
        String firstPart = cipherText.substring(2, 130);
        String sencondPart = cipherText.substring(130, length - 64);
        String lastPart = cipherText.substring(length - 64, length);
        return PREFIX + firstPart + lastPart + sencondPart;
    }

    public static FileResponse toFileResponse(FileResponse fileResponse) {
        if (fileResponse == null) {
            return null;
        }
        if (fileResponse instanceof GmUploadResponse) {
            GmUploadResponse gmUploadResponse = (GmUploadResponse)fileResponse;
            UploadResponse uploadResponse = new UploadResponse();
            uploadResponse.setFileId(gmUploadResponse.getFileId());
            uploadResponse.setNcid(gmUploadResponse.getNcid());
            return uploadResponse;
        }
        if (fileResponse instanceof GmDownloadResponse) {
            GmDownloadResponse gmDownloadResponse = (GmDownloadResponse)fileResponse;
            DownloadResponse downloadResponse = new DownloadResponse();
            downloadResponse.setNcid(gmDownloadResponse.getNcid());
            return downloadResponse;
        }
        if (fileResponse instanceof GmUploadErrorResponse) {
            GmUploadErrorResponse gmUploadErrorResponse = (GmUploadErrorResponse)fileResponse;
            UploadErrorResponse uploadErrorResponse = new UploadErrorResponse();
            uploadErrorResponse.setNcid(gmUploadErrorResponse.getNcid());
            uploadErrorResponse.setErrMsg(gmUploadErrorResponse.getErrMsg());
            return uploadErrorResponse;
        }
        if (fileResponse instanceof GmDownloadErrorResponse) {
            GmDownloadErrorResponse gmDownloadErrorResponse = (GmDownloadErrorResponse)fileResponse;
            DownloadErrorResponse downloadErrorResponse = new DownloadErrorResponse();
            downloadErrorResponse.setNcid(gmDownloadErrorResponse.getNcid());
            downloadErrorResponse.setErrMsg(gmDownloadErrorResponse.getErrMsg());
            return downloadErrorResponse;
        }
        return fileResponse;
    }

    public static FileResponse toGmFileResponse(FileResponse fileResponse) {
        if (fileResponse == null) {
            return null;
        }
        if (fileResponse instanceof UploadResponse) {
            UploadResponse uploadResponse = (UploadResponse)fileResponse;
            GmUploadResponse gmUploadResponse = new GmUploadResponse();
            gmUploadResponse.setFileId(uploadResponse.getFileId());
            gmUploadResponse.setNcid(uploadResponse.getNcid());
            return gmUploadResponse;
        }
        if (fileResponse instanceof DownloadResponse) {
            DownloadResponse downloadResponse = (DownloadResponse)fileResponse;
            GmDownloadResponse response = new GmDownloadResponse();
            response.setNcid(downloadResponse.getNcid());
            return response;
        }
        if (fileResponse instanceof UploadErrorResponse) {
            UploadErrorResponse uploadErrorResponse = (UploadErrorResponse)fileResponse;
            GmUploadErrorResponse response = new GmUploadErrorResponse();
            response.setNcid(uploadErrorResponse.getNcid());
            response.setErrMsg(uploadErrorResponse.getErrMsg());
            return response;
        }
        if (fileResponse instanceof DownloadErrorResponse) {
            DownloadErrorResponse downloadErrorResponse = (DownloadErrorResponse)fileResponse;
            GmDownloadErrorResponse response = new GmDownloadErrorResponse();
            response.setNcid(downloadErrorResponse.getNcid());
            response.setErrMsg(downloadErrorResponse.getErrMsg());
            return response;
        }
        return fileResponse;
    }

    public static FileRequest toGmFileRequest(FileRequest fileRequest) throws Exception {
        if (fileRequest == null) {
            return null;
        }
        if (fileRequest instanceof UploadRequest) {
            UploadRequest uploadRequest = (UploadRequest)fileRequest;
            GmUploadRequest gmUploadRequest = new GmUploadRequest();
            gmUploadRequest.setBizCode(uploadRequest.getBizCode());
            gmUploadRequest.setSignature(uploadRequest.getSignature());
            gmUploadRequest.setNcid(uploadRequest.getNcid());
            return gmUploadRequest;
        }
        if (fileRequest instanceof DownloadRequest) {
            DownloadRequest downloadRequest = (DownloadRequest)fileRequest;
            GmDownloadRequest gmDownloadRequest = new GmDownloadRequest();
            gmDownloadRequest.setFileId(downloadRequest.getFileId());
            gmDownloadRequest.setFileName(downloadRequest.getFileName());
            gmDownloadRequest.setBlockSize(downloadRequest.getBlockSize());
            gmDownloadRequest.setStartNum(downloadRequest.getStartNum());
            gmDownloadRequest.setNcid(downloadRequest.getNcid());
            gmDownloadRequest.setMessageBizType("I");
            return gmDownloadRequest;
        }
        if (fileRequest instanceof GmUploadRequest) {
            GmUploadRequest gmUploadRequest = (GmUploadRequest)fileRequest;
            GmUploadRequestV2 uploadRequest = new GmUploadRequestV2();
            uploadRequest.setBizCode(gmUploadRequest.getBizCode());
            uploadRequest.setSignature(gmUploadRequest.getSignature());
            uploadRequest.setNcid(gmUploadRequest.getNcid());
            return uploadRequest;
        }
        if (fileRequest instanceof GmDownloadRequest) {
            GmDownloadRequest gmDownloadRequest = (GmDownloadRequest)fileRequest;
            GmDownloadRequestV2 downloadRequest = new GmDownloadRequestV2();
            downloadRequest.setFileId(gmDownloadRequest.getFileId());
            downloadRequest.setFileName(gmDownloadRequest.getFileName());
            downloadRequest.setBlockSize(gmDownloadRequest.getBlockSize());
            downloadRequest.setStartNum(gmDownloadRequest.getStartNum());
            downloadRequest.setNcid(gmDownloadRequest.getNcid());
            return downloadRequest;
        }
        return fileRequest;
    }

    public static FileRequest toFileRequest(FileRequest fileRequest) throws Exception {
        if (fileRequest == null) {
            return null;
        }
        if (fileRequest instanceof GmUploadRequest) {
            GmUploadRequest gmUploadRequest = (GmUploadRequest)fileRequest;
            UploadRequest uploadRequest = new UploadRequest();
            uploadRequest.setBizCode(gmUploadRequest.getBizCode());
            uploadRequest.setSignature(gmUploadRequest.getSignature());
            uploadRequest.setNcid(gmUploadRequest.getNcid());
            return uploadRequest;
        }
        if (fileRequest instanceof GmDownloadRequest) {
            GmDownloadRequest gmDownloadRequest = (GmDownloadRequest)fileRequest;
            DownloadRequest downloadRequest = new DownloadRequest();
            downloadRequest.setFileId(gmDownloadRequest.getFileId());
            downloadRequest.setFileName(gmDownloadRequest.getFileName());
            downloadRequest.setBlockSize(gmDownloadRequest.getBlockSize());
            downloadRequest.setStartNum(gmDownloadRequest.getStartNum());
            downloadRequest.setNcid(gmDownloadRequest.getNcid());
            return downloadRequest;
        }
        return fileRequest;
    }

    public static byte[] formatKey(byte[] key) throws DcfirmException {
        if (key == null) {
            throw new DcfirmException(ExceptionCode.U108);
        }
        if (key.length > 16) {
            byte[] ret = new byte[16];
            System.arraycopy(key, 0, ret, 0, 16);
            return ret;
        }
        if (key.length == 16) {
            return key;
        }
        byte[] ret = new byte[16];
        System.arraycopy(key, 0, ret, 0, key.length);
        for (int i = 0; i < 16 - key.length; ++i) {
            ret[key.length + i] = 32;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\222.txt");
        String md5 = GMUtils.sm3DigestGen(file);
        System.out.println(md5);
    }
}

