/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.util;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

@Deprecated
public class SM4Util {
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static AlgorithmParameters defaultAlgorithmParameters;
    private static final Map<String, Cipher> cipherMap;
    private static final Map<String, Key> keyMap;

    public static byte[] generateKey() throws Exception {
        return SM4Util.generateKey(128);
    }

    public static String generateKeyString() throws Exception {
        return ByteUtils.toHexString(SM4Util.generateKey());
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String encryptEcb(String hexKey, String paramStr, String padding) throws Exception {
        String cipherText = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Util.encrypt_Ecb_Padding(keyData, srcData, padding);
        cipherText = ByteUtils.toHexString(cipherArray);
        return cipherText;
    }

    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data, String padding) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(padding, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText, String padding) throws Exception {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] cipherData = ByteUtils.fromHexString(cipherText);
        byte[] srcData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData, padding);
        decryptStr = new String(srcData, ENCODING);
        return decryptStr;
    }

    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText, String padding) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(padding, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static String encryptCBC(String hexKey, String paramStr, String padding) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Util.encrypt_Cbc_Padding(keyData, srcData, padding, new String[0]);
        result = ByteUtils.toHexString(cipherArray);
        return result;
    }

    public static String encryptCBCbyIV(String hexKey, String paramStr, String padding, String IV) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Util.encrypt_Cbc_Padding(keyData, srcData, padding, IV);
        result = ByteUtils.toHexString(cipherArray);
        return result;
    }

    public static byte[] encrypt_Cbc_Padding(byte[] key, byte[] data, String padding, String ... algorithmParameters) throws Exception {
        if (algorithmParameters.length == 0) {
            Cipher cipher = SM4Util.generateCbcCipher(padding, 1, key, new String[0]);
            return cipher.doFinal(data);
        }
        Cipher cipher = SM4Util.generateCbcCipher(padding, 1, key, algorithmParameters);
        return cipher.doFinal(data);
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = SM4Util.generateConmmonCipher(algorithmName, mode, key, null);
        return cipher;
    }

    private static Cipher generateCbcCipher(String algorithmName, int mode, byte[] key, String ... algorithmParameters) throws Exception {
        AlgorithmParameters algorithmParameter = null;
        algorithmParameter = algorithmParameters.length == 0 ? SM4Util.generateIV(new String[0]) : SM4Util.generateIV(algorithmParameters[0]);
        Cipher cipher = SM4Util.generateConmmonCipher(algorithmName, mode, key, algorithmParameter);
        return cipher;
    }

    public static Cipher generateConmmonCipher(String algorithmName, int mode, byte[] key, AlgorithmParameters algorithmParameter) throws Exception {
        String keyStr;
        Key sm4Key;
        Cipher cipher = cipherMap.get(algorithmName);
        if (cipher == null) {
            cipher = Cipher.getInstance(algorithmName, "BC");
        }
        if ((sm4Key = keyMap.get(keyStr = Arrays.toString(key))) == null) {
            sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        }
        if (null == algorithmParameter) {
            cipher.init(mode, sm4Key);
        } else {
            cipher.init(mode, sm4Key, algorithmParameter);
        }
        return cipher;
    }

    public static AlgorithmParameters generateIV(String ... text) throws Exception {
        byte[] iv = ByteUtils.fromHexString("00000000000000000000000000000000");
        if (text.length == 0) {
            AlgorithmParameters params = null;
            if (defaultAlgorithmParameters == null) {
                params = AlgorithmParameters.getInstance(ALGORITHM_NAME);
                params.init(new IvParameterSpec(iv));
                defaultAlgorithmParameters = params;
            } else {
                params = defaultAlgorithmParameters;
            }
            return params;
        }
        String ivStr = text[0];
        if (ivStr.length() == 32) {
            iv = ByteUtils.fromHexString(ivStr);
        } else if (ivStr.length() > 32) {
            iv = ByteUtils.fromHexString(ivStr.substring(0, 32));
        } else if (ivStr.length() < 32) {
            int ivStrLength = ivStr.length();
            StringBuffer sb = new StringBuffer();
            sb.append(ivStr);
            for (int i = ivStrLength; i < 32; ++i) {
                sb.append("0");
            }
            iv = ByteUtils.fromHexString(sb.toString());
        }
        AlgorithmParameters params = AlgorithmParameters.getInstance(ALGORITHM_NAME);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static String decryptCBC(String hexKey, String text, String padding) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] resultData = ByteUtils.fromHexString(text);
        byte[] srcData = SM4Util.decrypt_Cbc_Padding(keyData, resultData, padding, new String[0]);
        result = new String(srcData, ENCODING);
        return result;
    }

    public static String decryptCBCbyIV(String hexKey, String text, String padding, String IV) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] resultData = ByteUtils.fromHexString(text);
        byte[] srcData = SM4Util.decrypt_Cbc_Padding(keyData, resultData, padding, IV);
        result = new String(srcData, ENCODING);
        return result;
    }

    public static byte[] decrypt_Cbc_Padding(byte[] key, byte[] cipherText, String padding, String ... algorithmParameters) throws Exception {
        if (algorithmParameters.length == 0) {
            Cipher cipher = SM4Util.generateCbcCipher(padding, 2, key, new String[0]);
            return cipher.doFinal(cipherText);
        }
        Cipher cipher = SM4Util.generateCbcCipher(padding, 2, key, algorithmParameters[0]);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr, String padding) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] cipherData = ByteUtils.fromHexString(cipherText);
        byte[] decryptData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData, padding);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static void testMethod() throws Exception {
        String gmSm4KeyHexStr = "00000000000000000000000000000000";
        String encryptCBCbyIV = SM4Util.encryptCBC(gmSm4KeyHexStr, "c4a5b32769396796295c4493a74898d0", "SM4/CBC/PKCS7Padding");
        System.out.println("sm4(CBC)byIV\u52a0\u5bc6\u7ed3\u679c\uff1a" + encryptCBCbyIV);
        String decryptCBCbyIV = SM4Util.decryptCBC(gmSm4KeyHexStr, encryptCBCbyIV, "SM4/CBC/PKCS7Padding");
        System.out.println("sm4(CBC)byIV\u89e3\u5bc6\u7ed3\u679c\uff1a" + decryptCBCbyIV);
        String encryptCBCbyIV1 = SM4Util.encryptCBC(gmSm4KeyHexStr, "c4a5b32769396796295c4493a74898d0", "SM4/CBC/PKCS7Padding");
        System.out.println("sm4(CBC)byIV\u52a0\u5bc6\u7ed3\u679c\uff1a" + encryptCBCbyIV1);
        String decryptCBCbyIV1 = SM4Util.decryptCBC(gmSm4KeyHexStr, encryptCBCbyIV, "SM4/CBC/PKCS7Padding");
        System.out.println("sm4(CBC)byIV\u89e3\u5bc6\u7ed3\u679c\uff1a" + decryptCBCbyIV1);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        defaultAlgorithmParameters = null;
        cipherMap = new HashMap<String, Cipher>();
        keyMap = new HashMap<String, Key>();
    }
}

