/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.sm;

import com.cib.smtools.sm.CIBSMTools;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import shaded.org.bouncycastle.asn1.gm.GMNamedCurves;
import shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.engines.SM2Engine;
import shaded.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.ParametersWithID;
import shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.org.bouncycastle.crypto.signers.SM2Signer;
import shaded.org.bouncycastle.crypto.signers.StandardDSAEncoding;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.util.Strings;
import shaded.org.bouncycastle.util.encoders.Hex;

public class SM2 {
    public static final String ENGINE_MODE_C1C2C3 = "C1C2C3";
    public static final String ENGINE_MODE_C1C3C2 = "C1C3C2";
    private static final int NO_COMPRESS_LENGTH = 96;
    private static final int NO_COMPRESS_BYTE_LENGTH = 64;
    private static final String ALGORITHM = "sm2p256v1";
    private static ECDomainParameters eCDomainParameters = null;
    private static final ThreadLocal<SM2Engine> threadSM2Engine132 = new ThreadLocal();
    private static final ThreadLocal<SM2Engine> threadSM2Engine123 = new ThreadLocal();

    public static SM2Engine instanceSM2Engine() {
        SM2Engine sm2Engine = threadSM2Engine132.get();
        if (sm2Engine == null) {
            sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            threadSM2Engine132.set(sm2Engine);
        }
        return sm2Engine;
    }

    public static SM2Engine instanceSM2Engine123() {
        SM2Engine sm2Engine = threadSM2Engine123.get();
        if (sm2Engine == null) {
            sm2Engine = new SM2Engine(SM2Engine.Mode.C1C2C3);
            threadSM2Engine123.set(sm2Engine);
        }
        return sm2Engine;
    }

    public static Map<String, byte[]> genKeyPair() throws Exception {
        return SM2.genKeyPair(false);
    }

    public static Map<String, byte[]> genKeyPair(boolean isCompressedPK) throws Exception {
        CIBSMTools.checkStatus();
        ECDomainParameters domainParameters = SM2.instanceECDomainParameters();
        ECKeyPairGenerator keyPaireGenerater = new ECKeyPairGenerator();
        keyPaireGenerater.init(new ECKeyGenerationParameters(domainParameters, SecureRandom.getInstance("SHA1PRNG")));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPaireGenerater.generateKeyPair();
        ECPoint ecPoint = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getQ();
        String publicKeyHex = Hex.toHexString(ecPoint.getEncoded(isCompressedPK));
        BigInteger privateKey = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        HashMap<String, byte[]> keyPair = new HashMap<String, byte[]>();
        keyPair.put("publicKey", Hex.decode(publicKeyHex));
        keyPair.put("privateKey", SM2.formatRS(privateKey.toByteArray()));
        return keyPair;
    }

    public static byte[] encrypt(byte[] text, byte[] publicKey) throws Exception {
        return SM2.encrypt(text, publicKey, ENGINE_MODE_C1C3C2);
    }

    public static byte[] encrypt(byte[] text, byte[] publicKey, String mode) throws Exception {
        CIBSMTools.checkStatus();
        if (publicKey.length == 64) {
            publicKey = shaded.org.bouncycastle.util.Arrays.concatenate(Hex.decode("04"), publicKey);
        }
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName(ALGORITHM);
        ECDomainParameters domainParameters = SM2.instanceECDomainParameters();
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = ENGINE_MODE_C1C2C3.equals(mode) ? SM2.instanceSM2Engine123() : SM2.instanceSM2Engine();
        sm2Engine.init(true, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = sm2Engine.processBlock(text, 0, text.length);
        String cipherText = Hex.toHexString(arrayOfBytes);
        Arrays.fill(arrayOfBytes, (byte)0);
        if (cipherText.indexOf("04") == 0) {
            cipherText = cipherText.substring(2, cipherText.length());
        }
        return Hex.decode(cipherText);
    }

    public static byte[] decrypt(byte[] cipherText, byte[] privacyKey) throws Exception {
        return SM2.decrypt(cipherText, privacyKey, ENGINE_MODE_C1C3C2);
    }

    public static byte[] decrypt(byte[] cipherText, byte[] privacyKey, String mode) throws Exception {
        CIBSMTools.checkStatus();
        cipherText = shaded.org.bouncycastle.util.Arrays.concatenate(Hex.decode("04"), cipherText);
        ECDomainParameters domainParameters = SM2.instanceECDomainParameters();
        byte[] key = new byte[privacyKey.length + 1];
        System.arraycopy(privacyKey, 0, key, 1, privacyKey.length);
        BigInteger privateKeyD = new BigInteger(key);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = ENGINE_MODE_C1C2C3.equals(mode) ? SM2.instanceSM2Engine123() : SM2.instanceSM2Engine();
        sm2Engine.init(false, privateKeyParameters);
        byte[] arrayOfBytes = sm2Engine.processBlock(cipherText, 0, cipherText.length);
        return arrayOfBytes;
    }

    public static byte[] sign(byte[] text, byte[] privacyKey) throws Exception {
        return SM2.sign(text, privacyKey, Strings.toByteArray("1234567812345678"));
    }

    public static byte[] sign(byte[] text, byte[] privacyKey, byte[] uid) throws Exception {
        CIBSMTools.checkStatus();
        ECDomainParameters domainParameters = SM2.instanceECDomainParameters();
        BigInteger privateKeyD = new BigInteger(Hex.toHexString(privacyKey), 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Signer sm2Signer = new SM2Signer();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(privateKeyParameters, SecureRandom.getInstance("SHA1PRNG"));
        sm2Signer.init(true, new ParametersWithID(parametersWithRandom, uid));
        sm2Signer.update(text, 0, text.length);
        byte[] sign = sm2Signer.generateSignature();
        BigInteger[] rs = StandardDSAEncoding.INSTANCE.decode(domainParameters.getN(), sign);
        return SM2.regSinature(rs);
    }

    public static boolean verifySign(byte[] content, byte[] publicKey, byte[] signData) throws Exception {
        return SM2.verifySign(content, publicKey, signData, Strings.toByteArray("1234567812345678"));
    }

    public static boolean verifySign(byte[] content, byte[] publicKey, byte[] signData, byte[] uid) throws Exception {
        CIBSMTools.checkStatus();
        if (publicKey.length == 64) {
            publicKey = shaded.org.bouncycastle.util.Arrays.concatenate(Hex.decode("04"), publicKey);
        }
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName(ALGORITHM);
        ECDomainParameters domainParameters = SM2.instanceECDomainParameters();
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(publicKey);
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Signer sm2Signer = new SM2Signer();
        ParametersWithID parametersWithID = new ParametersWithID(publicKeyParameters, uid);
        sm2Signer.init(false, parametersWithID);
        sm2Signer.update(content, 0, content.length);
        byte[] r = new byte[33];
        System.arraycopy(signData, 0, r, 1, 32);
        byte[] s = new byte[33];
        System.arraycopy(signData, 32, s, 1, 32);
        BigInteger s1 = new BigInteger(r);
        BigInteger s2 = new BigInteger(s);
        byte[] asnSignData = StandardDSAEncoding.INSTANCE.encode(domainParameters.getN(), s1, s2);
        boolean verify = sm2Signer.verifySignature(asnSignData);
        return verify;
    }

    public static boolean selfCheck() throws Exception {
        try {
            String testStrData = "c194e872b807734ca808f7280c14700ec194e872b807734ca808f7280c14700e";
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("privateKey", "2E0A118770604F4679711AD800A27F9C3B524845196E32B966EC090845DC24C5");
            keyMap.put("publicKey", "1996EC795BD9F36A50D96042F8175083EDD6C9ED0AC0C1C5BBC42489A6132A26A58B426B993E63E5F6817D2FD0E8F76B56B003111D9AD48D01C45510A67842CE");
            String sign = "78F21D368634C0D00906DA638F718BA08E2E7BAF8C72613C8F7C71CC400691831ED415A4F63867768768E98EDFDA2BE2C15BD56CB8BC4B4DD938DB47CADA7BAD";
            String publicKey = (String)keyMap.get("publicKey");
            boolean bool = SM2.verifySign(Hex.decode(testStrData), Hex.decode(publicKey), Hex.decode(sign));
            boolean bl = bool = bool && SM2.sm2Test();
            if (!bool) {
                throw new Exception("Error code:10002");
            }
        }
        catch (Exception e) {
            throw new Exception("Error code:10002", e);
        }
        return true;
    }

    private static byte[] regSinature(BigInteger[] rs) {
        byte[] r = rs[0].toByteArray();
        byte[] s = rs[1].toByteArray();
        r = SM2.formatRS(r);
        s = SM2.formatRS(s);
        return shaded.org.bouncycastle.util.Arrays.concatenate(r, s);
    }

    private static byte[] formatRS(byte[] rs) {
        byte[] result = rs;
        if (result.length > 32) {
            result = shaded.org.bouncycastle.util.Arrays.copyOfRange(result, result.length - 32, result.length);
        } else if (result.length < 32) {
            byte[] temp = new byte[32];
            System.arraycopy(result, 0, temp, 32 - result.length, result.length);
            result = temp;
        }
        return result;
    }

    private static ECDomainParameters instanceECDomainParameters() {
        if (eCDomainParameters == null) {
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName(ALGORITHM);
            eCDomainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        }
        return eCDomainParameters;
    }

    private static boolean sm2Test() throws Exception {
        String privateKey = "14D427B4095F2AE53C061863158408C515894F0E4EE03DC628DE301F2ECB5D4B";
        String publicKey = "043D6746BC9ADB8FC38EF9A6464A41F0627ECA9EC931BE6A1E824F9C298C6488BF02E29FC532AA7FA3A8A3DA1A6D356A7294832036FF9CE7D8A662B0F5192BF0";
        String text1 = "0000000000000000";
        String cipherText1 = "D959988055DE3DAB85F85F94C643D7A871D604123D09550AFBA128C460B58C214C9FE52383451D26E87AF5C7C6A63CDB0C1FE1F378BA15D2110EFC9C0A62DF203D794EAF9BFB74AAFF481B5796995BC3B770DFF2D73F643644F10F8E14486F90C44D80F2B70C54AE";
        String text2 = "0102030405060708";
        String cipherText2 = "A4B587B264B17E7C1C158851997499ABD39C15BFDEEA1702980E25DFC760BAF64E9A045AF97754617550072B2C234F43F4038CDBEC3BC614ACF7E1C49CCCE28712454BC8D3234909FF23026766F2EC3A42C02C49D70F3296003521F88F3AE66965CD0611D72984BA";
        String result1 = Hex.toHexString(SM2.decrypt(Hex.decode(cipherText1), Hex.decode(privateKey)));
        String result2 = Hex.toHexString(SM2.decrypt(Hex.decode(cipherText2), Hex.decode(privateKey)));
        String cipherText3 = Hex.toHexString(SM2.encrypt(Hex.decode(text1), Hex.decode(publicKey)));
        String result3 = Hex.toHexString(SM2.decrypt(Hex.decode(cipherText3), Hex.decode(privateKey)));
        Map<String, byte[]> keyPair = SM2.genKeyPair();
        String cipherText4 = Hex.toHexString(SM2.encrypt(Hex.decode(text2), keyPair.get("publicKey")));
        String result4 = Hex.toHexString(SM2.decrypt(Hex.decode(cipherText4), keyPair.get("privateKey")));
        if (!text1.equals(result1)) {
            return false;
        }
        if (!text2.equals(result2)) {
            return false;
        }
        if (!text1.equals(result3)) {
            return false;
        }
        if (!text2.equals(result4)) {
            return false;
        }
        byte[] signData = SM2.sign(Hex.decode(text2), keyPair.get("privateKey"));
        boolean result5 = SM2.verifySign(Hex.decode(text2), keyPair.get("publicKey"), Hex.decode(Hex.toHexString(signData)));
        return result5;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

