/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.sm;

import SoftRandomGenerator.RandomGeneratorForJava;
import com.cib.smtools.sm.SM2;
import com.cib.smtools.sm.SM3;
import com.cib.smtools.sm.SM4;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.math3.special.Gamma;
import shaded.org.bouncycastle.util.Arrays;
import shaded.org.bouncycastle.util.encoders.Hex;

public class CIBSMTools {
    public static final int ERROR_CODE_10001 = 10001;
    public static final int ERROR_CODE_10002 = 10002;
    public static final int ERROR_CODE_10003 = 10003;
    public static final int ERROR_CODE_10004 = 10004;
    public static final int ERROR_CODE_10005 = 10005;
    public static final int ERROR_CODE_10006 = 10006;
    public static final int ERROR_CODE_10007 = 10007;
    public static final int ERROR_CODE_10008 = 10008;
    public static final int ERROR_CODE_10009 = 10009;
    public static final int ERROR_CODE_16001 = 16001;
    public static final int ERROR_CODE_16002 = 16002;
    public static final int ERROR_CODE_18001 = 18001;
    public static final String ERROR_CODE = "Error code:";
    private static int statusValue = 0;
    private static RandomGeneratorForJava random;
    private static final int MODE_4 = 4;
    private static final int MODE_8 = 8;
    private static final double SIGNIFICANCE_LEVEL = 0.01;

    public static void init() throws Exception {
        CIBSMTools.init("");
    }

    public static void init(String path) throws Exception {
        statusValue = 2;
        boolean resultBool = true;
        try {
            resultBool = SM2.selfCheck() && SM3.selfCheck() && SM4.selfCheck() && CIBSMTools.verifySign();
        }
        catch (Exception e) {
            e.printStackTrace();
            resultBool = false;
        }
        statusValue = resultBool ? 0 : 1;
        random = new RandomGeneratorForJava(path);
        if (random.getStatus() == 0 && !CIBSMTools.randomSelfCheck() && !CIBSMTools.randomSelfCheck()) {
            random.setStatus(3);
        }
    }

    public static String version() {
        return "1.0";
    }

    public static int status() {
        return statusValue;
    }

    public static byte[] getRandom(int len) throws Exception {
        switch (random.getStatus()) {
            case 1: {
                throw new Exception("Error code:10008");
            }
            case 2: {
                throw new Exception("Error code:10001");
            }
            case 3: {
                throw new Exception("Error code:10005");
            }
        }
        if (len < 1 || len > 32) {
            throw new Exception("Error code:18001");
        }
        byte[] buferr = new byte[len];
        random.GeneratorBuffer(buferr, len);
        return buferr;
    }

    public static byte[] getPublicKey() throws IOException {
        try (InputStream inputStream = null;){
            inputStream = CIBSMTools.class.getResourceAsStream("/smtools.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            byte[] byArray = Hex.decode(properties.get("publicKey").toString());
            return byArray;
        }
    }

    static void checkStatus() throws Exception {
        if (statusValue == -1) {
            throw new Exception("Error code:10001");
        }
        if (statusValue == 1) {
            throw new Exception("Error code:10009");
        }
    }

    static void setStaus(int status) {
        statusValue = status;
    }

    private static boolean verifySign() throws Exception {
        String publicKey = "91385676fc5ad314a18462e2deb201fc767bb021eee63846bfef3d385633875144895f532b81d60bdd08e41de6a73186c1f7726aca55b01e9d0219f1ec8e7c6e";
        Map<String, String> signatureMap = CIBSMTools.readSignature();
        boolean result = CIBSMTools.checkClasssSinature(signatureMap, publicKey) && CIBSMTools.checkConfigSinature(signatureMap, publicKey);
        return result;
    }

    private static Map<String, String> readSignature() throws Exception {
        try (InputStream signStream = null;){
            String readStr;
            signStream = CIBSMTools.class.getResourceAsStream("/sign");
            if (signStream == null) {
                throw new Exception("Error code:10006");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(signStream));
            String fileName = "";
            HashMap<String, String> signatureMap = new HashMap<String, String>();
            while ((readStr = reader.readLine()) != null) {
                String[] keyValue;
                if (readStr.contains("fileName")) {
                    keyValue = readStr.split(":");
                    fileName = keyValue[1];
                }
                if (!readStr.contains("sign")) continue;
                keyValue = readStr.split(":");
                String sign = keyValue[1];
                signatureMap.put(fileName, sign);
            }
            HashMap<String, String> hashMap = signatureMap;
            return hashMap;
        }
    }

    private static Set<String> initClassSet() {
        HashSet<String> classSet = new HashSet<String>();
        classSet.add("com.cib.smtools.sm.SM2");
        classSet.add("com.cib.smtools.sm.SM3");
        classSet.add("com.cib.smtools.sm.SM4");
        classSet.add("com.cib.smtools.sm.CIBSMTools");
        return classSet;
    }

    private static boolean checkClasssSinature(Map<String, String> signatureMap, String publicKey) throws Exception {
        Set<String> classSet = CIBSMTools.initClassSet();
        for (String clsName : classSet) {
            String clsPath = clsName.replace(".", "/") + ".class";
            byte[] classByte = CIBSMTools.readClassFile(clsPath);
            byte[] classHash = SM3.hash(classByte);
            String classSign = signatureMap.get(clsName);
            if (classSign == null) {
                throw new Exception("Error code:10006");
            }
            boolean bool = SM2.verifySign(classHash, Hex.decode(publicKey), Hex.decode(classSign));
            if (bool) continue;
            throw new Exception("Error code:10007");
        }
        return true;
    }

    private static boolean checkConfigSinature(Map<String, String> signatureMap, String publicKey) throws Exception {
        try (InputStream configStream = null;){
            int len;
            String configName = "smtools.properties";
            String configSign = signatureMap.get(configName);
            if (configSign == null) {
                throw new Exception("Error code:10006");
            }
            configStream = CIBSMTools.class.getResourceAsStream("/" + configName);
            if (configStream == null) {
                throw new Exception("Error code:10006");
            }
            byte[] configFileByte = null;
            byte[] lsbyte = null;
            byte[] temp = new byte[1024];
            while ((len = configStream.read(temp)) != -1) {
                if (configFileByte == null) {
                    lsbyte = new byte[len];
                    configFileByte = new byte[len];
                    System.arraycopy(temp, 0, lsbyte, 0, len);
                    System.arraycopy(temp, 0, configFileByte, 0, len);
                    continue;
                }
                lsbyte = configFileByte;
                configFileByte = new byte[lsbyte.length + len];
                System.arraycopy(lsbyte, 0, configFileByte, 0, lsbyte.length);
                System.arraycopy(temp, 0, configFileByte, lsbyte.length, len);
            }
            byte[] configFileHash = SM3.hash(configFileByte);
            boolean bool = SM2.verifySign(configFileHash, Hex.decode(publicKey), Hex.decode(configSign));
            if (!bool) {
                throw new Exception("Error code:10007");
            }
            boolean bl = true;
            return bl;
        }
    }

    private static byte[] readClassFile(String fileName) {
        try {
            int len;
            byte[] allbyte = null;
            InputStream resourceAsStream = CIBSMTools.class.getClassLoader().getResourceAsStream(fileName);
            byte[] temp = new byte[1024];
            while ((len = resourceAsStream.read(temp)) != -1) {
                byte[] lsbyte;
                if (allbyte == null) {
                    lsbyte = new byte[len];
                    allbyte = new byte[len];
                    System.arraycopy(temp, 0, lsbyte, 0, len);
                    System.arraycopy(temp, 0, allbyte, 0, len);
                    continue;
                }
                lsbyte = allbyte;
                allbyte = new byte[lsbyte.length + len];
                System.arraycopy(lsbyte, 0, allbyte, 0, lsbyte.length);
                System.arraycopy(temp, 0, allbyte, lsbyte.length, len);
            }
            return allbyte;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean randomSelfCheck() throws Exception {
        int totalLen = 4096;
        int singleLen = 32;
        byte[] testRandom = new byte[]{};
        for (int i = 0; i < totalLen / singleLen; ++i) {
            testRandom = Arrays.concatenate(testRandom, CIBSMTools.getRandom(32));
        }
        return CIBSMTools.pukeCheck(testRandom, 4) && CIBSMTools.pukeCheck(testRandom, 8);
    }

    private static boolean pukeCheck(byte[] random, int mode) {
        if (random == null || mode != 4 && mode != 8) {
            return false;
        }
        double v = 0.0;
        int num = random.length * 8 / mode;
        int nSize = (int)Math.pow(2.0, mode);
        int[] n = new int[nSize];
        Long ni2Sum = 0L;
        for (byte randomI : random) {
            int one;
            if (mode == 4) {
                int two;
                int n2 = one = randomI & 0xF;
                n[n2] = n[n2] + 1;
                int n3 = two = randomI >> 4 & 0xF;
                n[n3] = n[n3] + 1;
                continue;
            }
            int n4 = one = randomI & 0xFF;
            n[n4] = n[n4] + 1;
        }
        for (int i = 0; i < nSize; ++i) {
            ni2Sum = ni2Sum + (long)(n[i] * n[i]);
        }
        v = (double)nSize / (double)num * (double)ni2Sum.longValue() - (double)num;
        double p = Gamma.regularizedGammaQ(((double)nSize - 1.0) / 2.0, v / 2.0);
        return p > 0.01;
    }
}

