/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.uuid;

import java.security.SecureRandom;

public class RandomUniqueIdGenerator {
    private static final char[] PRINTABLE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679".toCharArray();
    private static final int DEFAULT_MAX_RANDOM_LENGTH = 32;
    private static SecureRandom randomizer = new SecureRandom();

    public static String getNewString() {
        byte[] random = RandomUniqueIdGenerator.getNewStringAsBytes();
        return RandomUniqueIdGenerator.convertBytesToString(random);
    }

    public static String getNewString(int length) {
        byte[] random = RandomUniqueIdGenerator.getNewStringAsBytes(length);
        return RandomUniqueIdGenerator.convertBytesToString(random);
    }

    private static byte[] getNewStringAsBytes() {
        return RandomUniqueIdGenerator.getNewStringAsBytes(32);
    }

    private static byte[] getNewStringAsBytes(int maximumRandomLength) {
        byte[] random = new byte[maximumRandomLength];
        randomizer.nextBytes(random);
        return random;
    }

    private static String convertBytesToString(byte[] random) {
        char[] output = new char[random.length];
        for (int i = 0; i < random.length; ++i) {
            int index = Math.abs(random[i] % PRINTABLE_CHARACTERS.length);
            output[i] = PRINTABLE_CHARACTERS[index];
        }
        return new String(output);
    }
}

