/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.support;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.StringUtils;

public class PaginationRequest<T> {
    private List<String> joinEntitys = new ArrayList<String>();
    private List<String> propertyNames = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();
    private int offset;
    private int limit;
    private int page;
    private List<Order> orders = new ArrayList<Order>();

    public PaginationRequest(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public PaginationRequest(int page, int offset, int limit) {
        this.page = page;
        this.offset = offset;
        this.limit = limit;
    }

    public void addCondition(String propertyName, Object value) {
        if (value != null) {
            if (value instanceof String && StringUtils.hasText((String)((String)value))) {
                this.propertyNames.add(propertyName);
                this.values.add(value);
            } else if (!(value instanceof String)) {
                this.propertyNames.add(propertyName);
                this.values.add(value);
            }
        }
    }

    public void addLikeCondition(String propertyName, String value) {
        if (value != null) {
            if (value instanceof String && StringUtils.hasText((String)value)) {
                this.propertyNames.add(propertyName);
                this.values.add(Restrictions.like((String)propertyName, (Object)value));
            } else if (!(value instanceof String)) {
                this.propertyNames.add(propertyName);
                this.values.add(Restrictions.like((String)propertyName, (Object)value));
            }
        }
    }

    public void addInCondition(String propertyName, Long[] value) {
        if (value != null) {
            this.propertyNames.add(propertyName);
            this.values.add(Restrictions.in((String)propertyName, (Object[])value));
        }
    }

    public void addInCondition(String propertyName, String[] value) {
        if (value != null) {
            this.propertyNames.add(propertyName);
            this.values.add(Restrictions.in((String)propertyName, (Object[])value));
        }
    }

    public void addOrCondition(String propertyName, String value) {
        if (value != null) {
            this.propertyNames.add(propertyName);
            this.values.add(Restrictions.or((Criterion[])new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}));
        }
    }

    public void addJoinEntity(String entityName) {
        this.joinEntitys.add(entityName);
    }

    public void addOrder(String propertyName, boolean ascending) {
        if (ascending) {
            this.orders.add(Order.asc((String)propertyName));
        } else {
            this.orders.add(Order.desc((String)propertyName));
        }
    }

    public void addOrder(String propertyName, String mode) {
        if ("ASC".equals(mode.toUpperCase())) {
            this.orders.add(Order.asc((String)propertyName));
        } else {
            this.orders.add(Order.desc((String)propertyName));
        }
    }

    public Object getPropertyValue(String propertyName) {
        int len = this.propertyNames.size();
        for (int i = 0; i < len; ++i) {
            if (!this.propertyNames.get(i).equals(propertyName)) continue;
            return this.values.get(i);
        }
        return null;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List<String> getJoinEntitys() {
        return this.joinEntitys;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public List<Order> getOrders() {
        return this.orders;
    }
}

