/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.support;

import com.starit.common.dao.jmx.SQLManager;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CustomSQL
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(CustomSQL.class);
    private Map<String, SQLBean> _sqlPool = new ConcurrentHashMap<String, SQLBean>();
    private static final String STRING_SPACE = " ";
    private final SAXReader saxReader = new SAXReader();
    private Configuration configuration = null;
    private StringTemplateLoader stringTemplateLoader = null;
    private Map<String, Long> configMap = new HashMap<String, Long>();
    private boolean reloadSQLFiles = false;
    private static CustomSQL instance = null;

    private CustomSQL() {
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        instance = (CustomSQL)context.getBean(CustomSQL.class);
        instance.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomSQL getInstance() {
        if (instance != null) return instance;
        Class<CustomSQL> clazz = CustomSQL.class;
        synchronized (CustomSQL.class) {
            if (instance != null) return instance;
            instance = new CustomSQL();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.reloadSQLFiles = Boolean.valueOf(System.getProperty("reloadSQLFiles"));
        try {
            Resource[] configs;
            this.configuration = new Configuration();
            this.stringTemplateLoader = new StringTemplateLoader();
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setNumberFormat("#");
            for (Resource _config : configs = this.loadConfigs()) {
                logger.info("Loading " + _config.getURL().getPath());
                this.configMap.put(_config.getURL().getPath(), _config.lastModified());
                this.read(_config.getInputStream());
            }
            this.configuration.setTemplateLoader((TemplateLoader)this.stringTemplateLoader);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        SQLManager manager = new SQLManager();
        this.register("com.starit.common.dao:type=SQLStat", manager);
    }

    private ObjectName register(String name, Object mbean) {
        try {
            ObjectName objectName = new ObjectName(name);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                mbeanServer.registerMBean(mbean, objectName);
            }
            catch (InstanceAlreadyExistsException ex) {
                mbeanServer.unregisterMBean(objectName);
                mbeanServer.registerMBean(mbean, objectName);
            }
            return objectName;
        }
        catch (JMException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    protected Resource[] loadConfigs() throws IOException {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        return patternResolver.getResources("classpath*:custom-sql/**/*.xml");
    }

    public String get(String id) {
        SQLBean bean;
        if (this.reloadSQLFiles) {
            try {
                this.reloadConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((bean = this._sqlPool.get(id)) == null) {
            throw new IllegalStateException("sql id \u4e0d\u5b58\u5728\uff1a" + id);
        }
        if ("simple".equals(bean.getTempateType())) {
            return this._sqlPool.get(id).getContent();
        }
        throw new RuntimeException("SQL \u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u53ea\u53ef\u4ee5\u662fsimple\u7c7b\u578b");
    }

    public String get(String id, Map<String, Object> models) {
        if (this.reloadSQLFiles) {
            try {
                this.reloadConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Template template = this.configuration.getTemplate(id);
            StringWriter writer = new StringWriter();
            template.process(models, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException e) {
            throw new RuntimeException("Parse sql failed", e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("sql id \u4e0d\u5b58\u5728\uff1a" + id);
        }
        catch (IOException e) {
            throw new RuntimeException("Parse sql failed", e);
        }
    }

    private void reloadConfig() throws IOException {
        Resource[] newConfigs;
        for (Resource newConfig : newConfigs = this.loadConfigs()) {
            boolean flag = true;
            for (Map.Entry<String, Long> entry : this.configMap.entrySet()) {
                if (!newConfig.getURL().getPath().equals(entry.getKey())) continue;
                flag = false;
                if (newConfig.getFile().lastModified() == entry.getValue().longValue()) continue;
                this.configMap.put(entry.getKey(), newConfig.getFile().lastModified());
                this.read(newConfig.getInputStream());
                logger.info("Reloading " + entry.getKey());
                break;
            }
            if (!flag) continue;
            this.configMap.put(newConfig.getURL().getPath(), newConfig.getFile().lastModified());
            this.read(newConfig.getInputStream());
            logger.info("Reloading " + newConfig.getURL().getPath());
        }
    }

    protected void read(InputStream is) {
        Document document;
        if (is == null) {
            return;
        }
        try {
            document = this.saxReader.read(is);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Element rootElement = document.getRootElement();
        for (Object sqlObj : rootElement.elements("sql")) {
            Element sqlElement = (Element)sqlObj;
            String id = sqlElement.attributeValue("id");
            String sqlType = sqlElement.attributeValue("sqlType");
            String tempateType = sqlElement.attributeValue("tempateType");
            if ("simple".equals(tempateType) || "freeMarker".equals(tempateType)) {
                String content = this.transform(sqlElement.getText());
                SQLBean bean = new SQLBean();
                bean.setTempateType(tempateType);
                bean.setSqlType(sqlType);
                bean.setContent(content);
                if ("freeMarker".equals(tempateType)) {
                    this.stringTemplateLoader.putTemplate(id, content);
                }
                this._sqlPool.put(id, bean);
                continue;
            }
            logger.warn("{} \u5bf9\u5e94 tempateType \u503c {} \u4e0d\u6b63\u786e\uff0c\u53ef\u9009\u503c\u4e3a\uff1asimple\u548cfreeMarker", (Object)id, (Object)sqlType);
        }
    }

    protected String transform(String sql) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(sql));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line.trim());
                sb.append(STRING_SPACE);
            }
            bufferedReader.close();
        }
        catch (IOException ioe) {
            return sql;
        }
        return sb.toString();
    }

    public Map<String, SQLBean> getAllSQL() {
        return this._sqlPool;
    }

    public StringTemplateLoader getStringTemplateLoader() {
        return this.stringTemplateLoader;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static class SQLBean {
        private String tempateType = "simple";
        private String sqlType = "SQL";
        private String content = "";

        public String getTempateType() {
            return this.tempateType;
        }

        public void setTempateType(String tempateType) {
            this.tempateType = tempateType;
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

