/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.service;

import com.starit.common.dao.hibernate4.HibernateBaseDao;
import com.starit.common.dao.service.BaseService;
import com.starit.common.dao.support.Pagination;
import com.starit.common.dao.support.PaginationRequest;
import com.starit.common.model.BaseEntity;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.engine.jdbc.LobCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;

public abstract class BaseServiceImpl<T, ID extends Serializable>
implements BaseService<T, ID>,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Class<T> entityClass;
    protected boolean isAssignableBaseEntity = true;

    public abstract HibernateBaseDao<T, ID> getHibernateBaseDao();

    public void afterPropertiesSet() throws Exception {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            this.entityClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            this.isAssignableBaseEntity = ClassUtils.isAssignable(BaseEntity.class, this.entityClass);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public T getEntity(ID id) {
        return this.getHibernateBaseDao().get(id);
    }

    @Transactional(readOnly=true)
    public List<T> findAllEntity() {
        return this.getHibernateBaseDao().loadAll();
    }

    @Override
    @Transactional
    public ID insertEntity(T entity) {
        return this.getHibernateBaseDao().save(entity);
    }

    @Override
    @Transactional
    public void updateEntity(T entity) {
        this.getHibernateBaseDao().update(entity);
    }

    @Override
    @Transactional
    public void createOrUpdate(T entity) {
        this.getHibernateBaseDao().saveOrUpdate(entity);
    }

    @Override
    @Transactional
    public T deleteEntity(ID id) {
        return this.getHibernateBaseDao().delete(id);
    }

    @Override
    @Transactional
    public T logicDeleteEntity(ID id) {
        T entity = this.getEntity(id);
        if (entity != null && entity instanceof BaseEntity) {
            BaseEntity be = (BaseEntity)entity;
            be.setDelFlag(1);
            this.updateEntity(be);
        }
        return entity;
    }

    @Override
    @Transactional
    public void bulkDeleteEntity(ID[] ids) {
        for (ID id : ids) {
            this.deleteEntity(id);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> loadEntities() {
        return this.getHibernateBaseDao().loadAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParam(String propertyName, Object value) {
        return this.getHibernateBaseDao().findByNamedParam(propertyName, value);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParam(String[] propertyNames, Object[] values) {
        return this.getHibernateBaseDao().findByNamedParam(propertyNames, values);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String propertyName, Object value, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(propertyName, value, order);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] propertyNames, Object[] values, Order ... orders) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(propertyNames, values, orders);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String joinEntity, String propertyName, Object value, Order order) {
        return this.findByNamedParamAndOrder(new String[]{joinEntity}, propertyName, value, order);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] joinEntitys, String propertyName, Object value, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(joinEntitys, new String[]{propertyName}, new Object[]{value}, new Order[]{order});
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] joinEntitys, String[] propertyNames, Object[] values, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(joinEntitys, propertyNames, values, new Order[]{order});
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<T> findPage(PaginationRequest<T> paginationRequest) {
        if (this.isAssignableBaseEntity) {
            paginationRequest.addCondition("delFlag", 0);
        }
        return this.getHibernateBaseDao().findPage(paginationRequest);
    }

    @Override
    public LobCreator getLobCreator() {
        return this.getHibernateBaseDao().getLobCreator();
    }
}

