/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.key;

import com.starit.common.dao.key.SingleSequence;
import com.starit.common.dao.key.UniqueTableApp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.support.TransactionTemplate;

public class SequenceFactory
implements ApplicationContextAware {
    private static Map<String, SingleSequence> singleSequenceMap = new ConcurrentHashMap<String, SingleSequence>();
    private static SequenceFactory factory;
    private TransactionTemplate transactionTemplate;
    private UniqueTableApp uniqueTableApp;
    private ApplicationContext context;
    private int cacheKeyNum = 10;

    private SequenceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SingleSequence getSequence(String name) {
        SingleSequence sequence = singleSequenceMap.get(name);
        if (sequence != null) return sequence;
        Class<SequenceFactory> clazz = SequenceFactory.class;
        synchronized (SequenceFactory.class) {
            if (sequence != null) return sequence;
            sequence = factory.createSequence(name);
            singleSequenceMap.put(name, sequence);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sequence;
        }
    }

    private SingleSequence createSequence(String name) {
        int cacheNum = this.getCacheKeyNum();
        SingleSequence sequence = new SingleSequence(cacheNum, this.uniqueTableApp, this.transactionTemplate);
        return sequence;
    }

    public void setUniqueTableApp(UniqueTableApp uniqueTableApp) {
        this.uniqueTableApp = uniqueTableApp;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        factory = (SequenceFactory)this.context.getBean(SequenceFactory.class);
    }

    public int getCacheKeyNum() {
        return this.cacheKeyNum;
    }

    public void setCacheKeyNum(int cacheKeyNum) {
        this.cacheKeyNum = cacheKeyNum;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

