/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.jmx;

import com.starit.common.dao.jmx.SQLManagerMBean;
import com.starit.common.dao.support.CustomSQL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLManager
implements SQLManagerMBean {
    private static final Logger _logger = LoggerFactory.getLogger(SQLManager.class);
    private ConcurrentMap<String, CompositeData> concurrentMap = new ConcurrentHashMap<String, CompositeData>();
    private TabularData data = null;
    private CompositeType COMPOSITE_TYPE = null;

    @Override
    public TabularData getUriList() throws JMException {
        return this.data;
    }

    @Override
    public String findSQL(String id) {
        CustomSQL.SQLBean bean = CustomSQL.getInstance().getAllSQL().get(id);
        if (bean == null) {
            return "sql id\u4e0d\u5b58\u5728";
        }
        return bean.getContent();
    }

    @Override
    public String resetSql(String id, String type, String sql) {
        CustomSQL.SQLBean bean = CustomSQL.getInstance().getAllSQL().get(id);
        if (bean == null) {
            return "sql id\u4e0d\u5b58\u5728";
        }
        if ("simple".equals(bean.getTempateType()) || "freeMarker".equals(bean.getTempateType())) {
            bean.setContent(sql);
            if ("freeMarker".equals(bean.getTempateType())) {
                CustomSQL.getInstance().getStringTemplateLoader().putTemplate(id, sql);
                CustomSQL.getInstance().getConfiguration().clearTemplateCache();
            }
            return "\u8bbe\u7f6e\u6210\u529f";
        }
        return "\u7c7b\u578b\u503c\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u662fsimple\u6216freeMarker";
    }

    @Override
    public long getSQLCount() {
        return this.data.size();
    }

    public SQLManager() {
        try {
            CompositeType rowType = this.getCompositeType();
            String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
            TabularType tabularType = new TabularType("SQLStatistic", "SQLStatistic", rowType, indexNames);
            this.data = new TabularDataSupport(tabularType);
            for (Map.Entry<String, CustomSQL.SQLBean> entry : CustomSQL.getInstance().getAllSQL().entrySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", entry.getKey());
                map.put("tempateType", entry.getValue().getTempateType());
                map.put("sqlType", entry.getValue().getSqlType());
                map.put("SQL", entry.getValue().getContent());
                CompositeDataSupport compositeData = new CompositeDataSupport(this.getCompositeType(), map);
                this.data.put(compositeData);
                this.concurrentMap.put(entry.getKey(), compositeData);
            }
        }
        catch (JMException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (this.COMPOSITE_TYPE != null) {
            return this.COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        String[] indexDescriptions = indexNames = new String[]{"id", "tempateType", "sqlType", "SQL"};
        this.COMPOSITE_TYPE = new CompositeType("SQLStatistic", "SQL Statistic", indexNames, indexDescriptions, indexTypes);
        return this.COMPOSITE_TYPE;
    }
}

