/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.jdbc.support;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAggregateExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.starit.common.dao.jdbc.SqlBuilder;
import java.util.List;

public abstract class AbstractSqlBuilder
implements SqlBuilder {
    @Override
    public String countSql(String sql) {
        List stmtList = SQLUtils.parseStatements((String)sql, (String)this.getDbType());
        if (stmtList.size() != 1) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new IllegalArgumentException("sql not support count : " + sql);
        }
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        String result = this.innerCountSql(selectStmt.getSelect()).trim();
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    public String limitSql(String sql, int offset, int count) {
        return this.innerLimitSql(sql, offset, count);
    }

    public abstract String innerLimitSql(String var1, int var2, int var3);

    private String innerCountSql(SQLSelect select) {
        if (select.getOrderBy() != null) {
            select.setOrderBy(null);
        }
        SQLSelectQuery query = select.getQuery();
        this.clearOrderBy(query);
        if (query instanceof SQLSelectQueryBlock) {
            SQLSelectItem countItem = this.createCountItem();
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getGroupBy() != null && queryBlock.getGroupBy().getItems().size() > 0) {
                return this.createCountUseSubQuery(select);
            }
            queryBlock.getSelectList().clear();
            queryBlock.getSelectList().add(countItem);
            return SQLUtils.toSQLString((SQLObject)select, (String)this.getDbType());
        }
        if (query instanceof SQLUnionQuery) {
            return this.createCountUseSubQuery(select);
        }
        throw new IllegalStateException();
    }

    protected abstract String getDbType();

    protected SQLSelectItem createCountItem() {
        Object countExpr = "oracle".equals(this.getDbType()) ? new OracleAggregateExpr("COUNT") : new SQLAggregateExpr("COUNT");
        countExpr.getArguments().add(new SQLAllColumnExpr());
        SQLSelectItem countItem = new SQLSelectItem((SQLExpr)countExpr);
        return countItem;
    }

    protected String createCountUseSubQuery(SQLSelect select) {
        SQLSelectQueryBlock countSelectQuery = this.createQueryBlock();
        SQLSelectItem countItem = this.createCountItem();
        countSelectQuery.getSelectList().add(countItem);
        SQLSubqueryTableSource fromSubquery = new SQLSubqueryTableSource(select);
        fromSubquery.setAlias("ALIAS_COUNT");
        countSelectQuery.setFrom((SQLTableSource)fromSubquery);
        SQLSelect countSelect = new SQLSelect();
        countSelect.setQuery((SQLSelectQuery)countSelectQuery);
        SQLSelectStatement countStmt = new SQLSelectStatement(countSelect);
        return SQLUtils.toSQLString((SQLObject)countStmt, (String)this.getDbType());
    }

    protected abstract SQLSelectQueryBlock createQueryBlock();

    protected void clearOrderBy(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            PGSelectQueryBlock pgQueryBlock;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock instanceof MySqlSelectQueryBlock) {
                MySqlSelectQueryBlock mysqlQueryBlock = (MySqlSelectQueryBlock)queryBlock;
                if (mysqlQueryBlock.getOrderBy() != null) {
                    mysqlQueryBlock.setOrderBy(null);
                }
            } else if (queryBlock instanceof PGSelectQueryBlock && (pgQueryBlock = (PGSelectQueryBlock)queryBlock).getOrderBy() != null) {
                pgQueryBlock.setOrderBy(null);
            }
            return;
        }
        if (query instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)query;
            if (union.getOrderBy() != null) {
                union.setOrderBy(null);
            }
            this.clearOrderBy(union.getLeft());
            this.clearOrderBy(union.getRight());
        }
    }
}

