/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.jdbc;

import com.starit.common.dao.jdbc.SqlBuilder;
import com.starit.common.dao.support.Pagination;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class NamedParameterJdbcPager {
    private SqlBuilder builder;
    private NamedParameterJdbcTemplate jdbcTemplate;

    public NamedParameterJdbcPager(DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public Pagination<Map<String, Object>> queryPage(String sql, int offset, int limit) {
        return this.queryPage(sql, offset, limit, null);
    }

    public Pagination<Map<String, Object>> queryPage(String sql, int offset, int limit, Map<String, Object> paramMap) {
        String countSql = this.builder.countSql(sql);
        String limitSql = this.builder.limitSql(sql, offset, limit);
        long totalRecords = (Long)this.jdbcTemplate.queryForObject(countSql, paramMap, Long.class);
        List items = this.jdbcTemplate.queryForList(limitSql, paramMap);
        double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
        Pagination<Map<String, Object>> page = new Pagination<Map<String, Object>>((long)totalPages, offset, limit, totalRecords, items);
        return page;
    }

    public SqlBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(SqlBuilder builder) {
        this.builder = builder;
    }
}

