/*
 * Decompiled with CFR 0.152.
 */
package com.starit.common.dao.hibernate4;

import com.starit.common.dao.hibernate4.HibernateBaseDao;
import com.starit.common.dao.hibernate4.HibernateCallback;
import com.starit.common.dao.support.Pagination;
import com.starit.common.dao.support.PaginationRequest;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.util.Assert;

public class HibernateBaseDaoImpl<T, ID extends Serializable>
implements HibernateBaseDao<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateBaseDaoImpl.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private SessionFactory sessionFactory;
    protected Class<T> entityClass;
    protected String entityName;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;
    private int fetchSize = 0;
    private int maxResults = 0;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SQLExceptionTranslator defaultJdbcExceptionTranslator;

    @PostConstruct
    public void postConstruct() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            this.entityClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        ClassMetadata classMetadata = this.sessionFactory.getClassMetadata(this.entityClass);
        this.entityName = classMetadata.getEntityName();
    }

    @Override
    public LobCreator getLobCreator() {
        return Hibernate.getLobCreator((Session)this.sessionFactory.getCurrentSession());
    }

    @Override
    public T get(ID id) throws DataAccessException {
        return (T)this.doExecute(new HibernateCallback<T>((Serializable)id){
            final /* synthetic */ Serializable val$id;
            {
                this.val$id = serializable;
            }

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                return session.get(HibernateBaseDaoImpl.this.entityClass, this.val$id);
            }
        });
    }

    @Override
    public T get(ID id, LockOptions lockOption) throws DataAccessException {
        return (T)this.doExecute(new HibernateCallback<T>((Serializable)id, lockOption){
            final /* synthetic */ Serializable val$id;
            final /* synthetic */ LockOptions val$lockOption;
            {
                this.val$id = serializable;
                this.val$lockOption = lockOptions;
            }

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                return session.get(HibernateBaseDaoImpl.this.entityClass, this.val$id, this.val$lockOption);
            }
        });
    }

    @Override
    public T load(ID id) throws DataAccessException {
        return (T)this.doExecute(new HibernateCallback<T>((Serializable)id){
            final /* synthetic */ Serializable val$id;
            {
                this.val$id = serializable;
            }

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                return session.load(HibernateBaseDaoImpl.this.entityClass, this.val$id);
            }
        });
    }

    @Override
    public T load(ID id, LockOptions lockOption) throws DataAccessException {
        return (T)this.doExecute(new HibernateCallback<T>((Serializable)id, lockOption){
            final /* synthetic */ Serializable val$id;
            final /* synthetic */ LockOptions val$lockOption;
            {
                this.val$id = serializable;
                this.val$lockOption = lockOptions;
            }

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                return session.load(HibernateBaseDaoImpl.this.entityClass, this.val$id, this.val$lockOption);
            }
        });
    }

    @Override
    public List<T> loadAll() throws DataAccessException {
        return (List)this.doExecute(new HibernateCallback<List<T>>(){

            @Override
            public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(HibernateBaseDaoImpl.this.entityClass);
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                HibernateBaseDaoImpl.this.prepareCriteria(criteria);
                return criteria.list();
            }
        });
    }

    @Override
    public void load(final T entity, ID id) throws DataAccessException {
        this.doExecute(new HibernateCallback<T>((Serializable)id){
            final /* synthetic */ Serializable val$id;
            {
                this.val$id = serializable;
            }

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                session.load(entity, this.val$id);
                return null;
            }
        });
    }

    @Override
    public void refresh(T entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    @Override
    public void refresh(final T entity, final LockOptions lockOption) throws DataAccessException {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                if (lockOption == null) {
                    session.refresh(entity);
                } else {
                    session.refresh(entity, lockOption);
                }
                return null;
            }
        });
    }

    @Override
    public boolean contains(final T entity) throws DataAccessException {
        return this.doExecute(new HibernateCallback<Boolean>(){

            @Override
            public Boolean doInHibernate(Session session) throws HibernateException, SQLException {
                return session.contains(entity);
            }
        });
    }

    @Override
    public void evict(final T entity) throws DataAccessException {
        this.doExecute(new HibernateCallback<Boolean>(){

            @Override
            public Boolean doInHibernate(Session session) throws HibernateException, SQLException {
                session.evict(entity);
                return null;
            }
        });
    }

    @Override
    public void initialize(T proxy) throws DataAccessException {
        try {
            Hibernate.initialize(proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
        }
    }

    @Override
    public Serializable getIdentifierObject(T entity) {
        if (entity == null) {
            logger.warn("Unable to determine the identifier for an empty object");
            return null;
        }
        ClassMetadata cm = this.sessionFactory.getClassMetadata(this.entityClass);
        if (cm == null) {
            throw new RuntimeException("gIO(): Unable to get class metadata for " + this.entityClass.getSimpleName());
        }
        return cm.getIdentifier(entity);
    }

    @Override
    public void lock(final T entity, final LockOptions lockOption) {
        this.doExecute(new HibernateCallback<Boolean>(){

            @Override
            public Boolean doInHibernate(Session session) throws HibernateException, SQLException {
                session.buildLockRequest(lockOption).lock(entity);
                return null;
            }
        });
    }

    @Override
    public ID save(final T entity) {
        return (ID)((Serializable)this.doExecute(new HibernateCallback<ID>(){

            @Override
            public ID doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                return session.save(entity);
            }
        }));
    }

    @Override
    public void update(T entity) {
        this.update(entity, null);
    }

    @Override
    public void update(final T entity, final LockOptions lockOption) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                session.update(entity);
                if (lockOption != null) {
                    session.buildLockRequest(lockOption).lock(entity);
                }
                return null;
            }
        });
    }

    @Override
    public void saveOrUpdate(final T entity) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entity);
                return null;
            }
        });
    }

    @Override
    public void saveOrUpdateAll(final Collection<T> entities) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                for (Object entity : entities) {
                    session.saveOrUpdate(entity);
                }
                return null;
            }
        });
    }

    @Override
    public void replicate(final T entity, final ReplicationMode replicationMode) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                session.replicate(entity, replicationMode);
                return null;
            }
        });
    }

    @Override
    public void persist(final T entity) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                session.persist(entity);
                return null;
            }
        });
    }

    @Override
    public T merge(final T entity) {
        return (T)this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                return session.merge(entity);
            }
        });
    }

    @Override
    public void delete(T entity) {
        this.delete(entity, null);
    }

    @Override
    public T delete(ID id) {
        T entity = this.get(id);
        if (entity != null) {
            this.delete((ID)entity);
        }
        return entity;
    }

    @Override
    public void delete(final T entity, final LockOptions lockOption) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                if (lockOption != null) {
                    session.buildLockRequest(lockOption).lock(entity);
                }
                session.delete(entity);
                return null;
            }
        });
    }

    @Override
    public void deleteAll(final Collection<T> entities) {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                HibernateBaseDaoImpl.this.checkWriteOperationAllowed(session);
                for (Object entity : entities) {
                    session.delete(entity);
                }
                return null;
            }
        });
    }

    @Override
    public void flush() {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                session.flush();
                return null;
            }
        });
    }

    @Override
    public void clear() {
        this.doExecute(new HibernateCallback<T>(){

            @Override
            public T doInHibernate(Session session) throws HibernateException, SQLException {
                session.clear();
                return null;
            }
        });
    }

    @Override
    public List findByHQL(String queryString) {
        return this.findByHQL(queryString, (Object[])null);
    }

    @Override
    public List findByHQL(String queryString, Object value) {
        return this.findByHQL(queryString, new Object[]{value});
    }

    @Override
    public List findByHQL(final String queryString, final Object ... values) {
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery(queryString);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List findByHQLNamedParam(String queryString, String paramName, Object value) {
        return this.findByHQLNamedParam(queryString, new String[]{paramName}, new Object[]{value});
    }

    @Override
    public List findByHQLNamedParam(final String queryString, final String[] paramNames, final Object[] values) {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery(queryString);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateBaseDaoImpl.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List findByHQLValueBean(final String queryString, final Object valueBean) {
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery(queryString);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    @Override
    public Pagination<Object> findPageByHQL(String rowSql, String countSql, int offset, int limit) {
        return this.findPageByHQL(rowSql, countSql, offset, limit, new String[0], new Object[0]);
    }

    @Override
    public Pagination<Object> findPageByHQL(String rowSql, String countSql, int offset, int limit, String propertyName, Object value) {
        return this.findPageByHQL(rowSql, countSql, offset, limit, new String[]{propertyName}, new Object[]{value});
    }

    @Override
    public Pagination<Object> findPageByHQL(final String rowSql, final String countSql, final int offset, final int limit, final String[] propertyNames, final Object[] values) {
        return this.doExecute(new HibernateCallback<Pagination<Object>>(){

            @Override
            public Pagination<Object> doInHibernate(Session session) throws HibernateException {
                Query rowQuery = session.createQuery(rowSql).setFirstResult(offset).setMaxResults(limit);
                Query countQuery = session.createQuery(countSql);
                int len = propertyNames.length;
                for (int i = 0; i < len; ++i) {
                    if (values[i] == null) continue;
                    rowQuery.setParameter(propertyNames[i], values[i]);
                    countQuery.setParameter(propertyNames[i], values[i]);
                }
                long totalRecords = (Long)countQuery.uniqueResult();
                List items = rowQuery.list();
                double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
                Pagination<Object> page = new Pagination<Object>((long)totalPages, offset, limit, totalRecords, items);
                return page;
            }
        });
    }

    @Override
    public List<T> findByNamedParam(String propertyName, Object value) {
        return this.findByNamedParamAndOrder(null, new String[]{propertyName}, new Object[]{value}, null);
    }

    @Override
    public List<T> findByNamedParam(String joinEntity, String propertyName, Object value) {
        return this.findByNamedParamAndOrder(new String[]{joinEntity}, new String[]{propertyName}, new Object[]{value}, null);
    }

    @Override
    public List<T> findByNamedParamAndOrder(String propertyName, Object value, Order order) {
        return this.findByNamedParamAndOrder(null, new String[]{propertyName}, new Object[]{value}, new Order[]{order});
    }

    @Override
    public List<T> findByNamedParamAndOrder(String joinEntity, String propertyName, Object value, Order order) {
        return this.findByNamedParamAndOrder(new String[]{joinEntity}, new String[]{propertyName}, new Object[]{value}, new Order[]{order});
    }

    @Override
    public List<T> findByNamedParam(String[] propertyNames, Object[] values) {
        return this.findByNamedParamAndOrder(null, propertyNames, values, null);
    }

    @Override
    public List<T> findByNamedParamAndOrder(String[] propertyNames, Object[] values, Order[] orders) {
        return this.findByNamedParamAndOrder(null, propertyNames, values, orders);
    }

    @Override
    public List<T> findByNamedParamAndOrder(String[] joinEntitys, String[] propertyNames, Object[] values, Order[] orders) {
        DetachedCriteria criteria = this.createDetachedCriteria(joinEntitys, propertyNames, values);
        if (orders != null) {
            for (Order order : orders) {
                criteria.addOrder(order);
            }
        }
        return this.findByCriteria(criteria);
    }

    @Override
    public Pagination<T> findPageByNamedParam(String joinEntity, String propertyName, Object value, int offset, int limit) {
        return this.findPageByNamedParamAndOrder(new String[]{joinEntity}, new String[]{propertyName}, new Object[]{value}, null, offset, limit);
    }

    @Override
    public Pagination<T> findPageByNamedParam(String propertyName, Object value, int offset, int limit) {
        return this.findPageByNamedParamAndOrder(null, new String[]{propertyName}, new Object[]{value}, null, offset, limit);
    }

    @Override
    public Pagination<T> findPageByNamedParamAndOrder(String propertyName, Object value, Order order, int offset, int limit) {
        return this.findPageByNamedParamAndOrder(null, new String[]{propertyName}, new Object[]{value}, new Order[]{order}, offset, limit);
    }

    @Override
    public Pagination<T> findPageByNamedParam(String[] propertyNames, Object[] values, int offset, int limit) {
        return this.findPageByNamedParamAndOrder(null, propertyNames, values, null, offset, limit);
    }

    @Override
    public Pagination<T> findPageByNamedParamAndOrder(String[] propertyNames, Object[] values, Order[] orders, int offset, int limit) {
        return this.findPageByNamedParamAndOrder(null, propertyNames, values, orders, offset, limit);
    }

    @Override
    public Pagination<T> findPageByNamedParamAndOrder(String[] joinEntitys, String[] propertyNames, Object[] values, final Order[] orders, final int offset, final int limit) {
        final DetachedCriteria criteria = this.createDetachedCriteria(joinEntitys, propertyNames, values);
        return (Pagination)this.doExecute(new HibernateCallback<Pagination<T>>(){

            @Override
            public Pagination<T> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                long totalRecords = (Long)executableCriteria.setProjection(Projections.rowCount()).uniqueResult();
                executableCriteria.setProjection(null);
                if (orders != null) {
                    for (Order order : orders) {
                        criteria.addOrder(order);
                    }
                }
                List items = executableCriteria.setFirstResult(offset).setMaxResults(limit).list();
                double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
                Pagination page = new Pagination((long)totalPages, offset, limit, totalRecords, items);
                return page;
            }
        });
    }

    @Override
    public Pagination<T> findPage(final PaginationRequest<T> paginationRequest) {
        final DetachedCriteria criteria = this.createDetachedCriteria(paginationRequest.getJoinEntitys(), paginationRequest.getPropertyNames(), paginationRequest.getValues());
        return (Pagination)this.doExecute(new HibernateCallback<Pagination<T>>(){

            @Override
            public Pagination<T> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                long totalRecords = (Long)executableCriteria.setProjection(Projections.rowCount()).uniqueResult();
                executableCriteria.setProjection(null);
                if (paginationRequest.getOrders() != null) {
                    for (Order order : paginationRequest.getOrders()) {
                        criteria.addOrder(order);
                    }
                }
                int offset = paginationRequest.getOffset();
                int limit = paginationRequest.getLimit();
                List items = executableCriteria.setFirstResult(offset).setMaxResults(limit).list();
                double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
                Pagination page = new Pagination(paginationRequest.getPage(), (long)totalPages, offset, limit, totalRecords, items);
                return page;
            }
        });
    }

    @Override
    public List findByNamedQuery(String queryName) {
        return this.findByNamedQuery(queryName, (Object[])null);
    }

    @Override
    public List findByNamedQuery(String queryName, Object value) {
        return this.findByNamedQuery(queryName, new Object[]{value});
    }

    @Override
    public List findByNamedQuery(final String queryName, final Object ... values) {
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) {
        return this.findByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value});
    }

    @Override
    public List findByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values) {
        if (paramNames != null && values != null && paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateBaseDaoImpl.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public List findByNamedQueryAndValueBean(final String queryName, final Object valueBean) {
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    @Override
    public List findByCriteria(final DetachedCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"DetachedCriteria must not be null");
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                return executableCriteria.list();
            }
        });
    }

    @Override
    public Long findCountByCriteria(final DetachedCriteria criteria) {
        return this.doExecute(new HibernateCallback<Long>(){

            @Override
            public Long doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                long totalCount = (Long)executableCriteria.setProjection(Projections.rowCount()).uniqueResult();
                return totalCount;
            }
        });
    }

    @Override
    public Pagination<T> findPageByCriteria(final DetachedCriteria criteria, final int offset, final int limit) {
        return (Pagination)this.doExecute(new HibernateCallback<Pagination<T>>(){

            @Override
            public Pagination<T> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                long totalRecords = (Long)executableCriteria.setProjection(Projections.rowCount()).uniqueResult();
                executableCriteria.setProjection(null);
                List items = executableCriteria.setFirstResult(offset).setMaxResults(limit).list();
                double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
                Pagination page = new Pagination((long)totalPages, offset, limit, totalRecords, items);
                return page;
            }
        });
    }

    @Override
    public List<T> findByExample(final T exampleEntity) throws DataAccessException {
        Assert.notNull(exampleEntity, (String)"Example entity must not be null");
        return this.doExecute(new HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = HibernateBaseDaoImpl.this.entityName != null ? session.createCriteria(HibernateBaseDaoImpl.this.entityName) : session.createCriteria(exampleEntity.getClass());
                executableCriteria.add((Criterion)Example.create((Object)exampleEntity));
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                return executableCriteria.list();
            }
        });
    }

    @Override
    public Pagination<T> findPageByExample(final int offset, final int limit) {
        return (Pagination)this.doExecute(new HibernateCallback<Pagination<T>>(){

            @Override
            public Pagination<T> doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = session.createCriteria(HibernateBaseDaoImpl.this.entityClass);
                HibernateBaseDaoImpl.this.prepareCriteria(executableCriteria);
                long totalRecords = (Long)executableCriteria.setProjection(Projections.rowCount()).uniqueResult();
                executableCriteria.setProjection(null);
                List items = executableCriteria.setFirstResult(offset).setMaxResults(limit).list();
                double totalPages = Math.ceil((double)totalRecords * 1.0 / (double)limit);
                Pagination page = new Pagination((int)totalPages, offset, limit, totalRecords, items);
                return page;
            }
        });
    }

    @Override
    public Iterator iterate(String queryString) {
        return this.iterate(queryString, (Object[])null);
    }

    @Override
    public Iterator iterate(String queryString, Object value) {
        return this.iterate(queryString, new Object[]{value});
    }

    @Override
    public Iterator iterate(final String queryString, final Object ... values) {
        return this.doExecute(new HibernateCallback<Iterator>(){

            @Override
            public Iterator doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.iterate();
            }
        });
    }

    @Override
    public void closeIterator(Iterator it) {
        try {
            Hibernate.close((Iterator)it);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
        }
    }

    @Override
    public int bulkUpdate(String queryString) {
        return this.bulkUpdate(queryString, (Object[])null);
    }

    @Override
    public int bulkUpdate(String queryString, Object value) {
        return this.bulkUpdate(queryString, new Object[]{value});
    }

    @Override
    public int bulkUpdate(final String queryString, final Object ... values) {
        return this.doExecute(new HibernateCallback<Integer>(){

            @Override
            public Integer doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateBaseDaoImpl.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.executeUpdate();
            }
        });
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            criteria.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            criteria.setMaxResults(this.getMaxResults());
        }
    }

    protected DetachedCriteria createDetachedCriteria(String[] joinEntitys, String[] propertyNames, Object[] values) {
        if (joinEntitys != null) {
            return this.createDetachedCriteria(Arrays.asList(joinEntitys), Arrays.asList(propertyNames), Arrays.asList(values));
        }
        return this.createDetachedCriteria(null, Arrays.asList(propertyNames), Arrays.asList(values));
    }

    protected DetachedCriteria createDetachedCriteria(List<String> joinEntitys, List<String> propertyNames, List<Object> values) {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass);
        if (joinEntitys != null) {
            for (String joinEntity : joinEntitys) {
                criteria.setFetchMode(joinEntity, FetchMode.JOIN);
                criteria.createAlias(joinEntity, joinEntity);
            }
        }
        int len = propertyNames.size();
        for (int i = 0; i < len; ++i) {
            String propertyName = propertyNames.get(i);
            Object value = values.get(i);
            if (value instanceof Criterion) {
                criteria.add((Criterion)value);
                continue;
            }
            if (value instanceof Collection) {
                criteria.add(Restrictions.in((String)propertyName, (Collection)((Collection)value)));
                continue;
            }
            if (value.getClass().isArray()) {
                criteria.add(Restrictions.in((String)propertyName, (Object[])((Object[])value)));
                continue;
            }
            if (value instanceof Map) {
                SimpleExpression rhs;
                SimpleExpression lhs;
                Iterator iterator = ((Map)value).entrySet().iterator();
                Map.Entry entry = iterator.next();
                if ("like".equals(propertyName)) {
                    lhs = Restrictions.like((String)((String)entry.getKey()), entry.getValue());
                    entry = iterator.next();
                    rhs = Restrictions.like((String)((String)entry.getKey()), entry.getValue());
                } else {
                    lhs = Restrictions.eq((String)((String)entry.getKey()), entry.getValue());
                    entry = iterator.next();
                    rhs = Restrictions.eq((String)((String)entry.getKey()), entry.getValue());
                }
                lhs = Restrictions.or((Criterion)lhs, (Criterion)rhs);
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    rhs = "like".equals(propertyName) ? Restrictions.like((String)((String)entry.getKey()), entry.getValue()) : Restrictions.eq((String)((String)entry.getKey()), entry.getValue());
                    lhs = Restrictions.or((Criterion)lhs, (Criterion)rhs);
                }
                criteria.add((Criterion)lhs);
                continue;
            }
            criteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        }
        return criteria;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    protected <R> R doExecute(HibernateCallback<R> action) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            R result = action.doInHibernate(session);
            return result;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
        catch (SQLException e) {
            throw this.convertJdbcAccessException(e);
        }
    }

    public DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (this.getJdbcExceptionTranslator() != null && ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex, this.getJdbcExceptionTranslator());
        }
        if (GenericJDBCException.class.equals(((Object)((Object)ex)).getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)ex), this.getDefaultJdbcExceptionTranslator());
        }
        return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex, SQLExceptionTranslator translator) {
        return translator.translate("Hibernate operation: " + ex.getMessage(), ex.getSQL(), ex.getSQLException());
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        SQLExceptionTranslator translator = this.getJdbcExceptionTranslator();
        if (translator == null) {
            translator = this.getDefaultJdbcExceptionTranslator();
        }
        return translator.translate("Hibernate-related JDBC operation", null, ex);
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && session.getFlushMode().lessThan(FlushMode.COMMIT)) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.MANUAL): Turn your Session into FlushMode.COMMIT/AUTO or remove 'readOnly' marker from transaction definition.");
        }
    }

    protected void prepareQuery(Query queryObject) {
        if (this.isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            queryObject.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            queryObject.setMaxResults(this.getMaxResults());
        }
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getDefaultJdbcExceptionTranslator() {
        return this.defaultJdbcExceptionTranslator;
    }

    public void setDefaultJdbcExceptionTranslator(SQLExceptionTranslator defaultJdbcExceptionTranslator) {
        this.defaultJdbcExceptionTranslator = defaultJdbcExceptionTranslator;
    }

    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.checkWriteOperations = checkWriteOperations;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String queryCacheRegion) {
        this.queryCacheRegion = queryCacheRegion;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }
}

